% Example digital filter design
% Course: Analog and Digital Filter Design
% Lecture: Design of a digital filter
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/03/20$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc, format short e
path(path,'c:\afd\drawfilt')

G =[0.1932
    0.0543
    0.8913];

SOS =[1  2  1    1   -1.0202    0.7929
      1  2  1    1   -1.2869    0.5039];

subplot(2,1,1)
dfont = 9;
drawin(2, 10, 'x',2,5,dfont,'b');
drawout(37,10, 'y',0,5,dfont,'b');
coef1 = num2str(G(3));
% coef1 = '{\its}_3';
drawmult(34,10,37,' ',coef1,0,5/3,dfont,'b');

section = 1;
c = [G(section) SOS(section,5:6) SOS(section,1:3)];
for ind=1:6; coefs{ind}=num2str(c(ind)); end
% coefs = {'{\its}_1' '{\ita}_{1,2}' '{\ita}_{1,3}' '{\itb}_{1,1}' '{\itb}_{1,2}' '{\itb}_{1,3}'};
drawDF2nd(0,0,4,5,dfont,coefs,'b');

section = 2;
c = [G(section) SOS(section,5:6) SOS(section,1:3)];
for ind=1:6; coefs{ind}=num2str(c(ind)); end
% coefs = {'{\its}_2' '{\ita}_{2,2}' '{\ita}_{2,3}' '{\itb}_{2,1}' '{\itb}_{2,2}' '{\itb}_{2,3}'};
drawDF2nd(16,0,4,5,dfont,coefs,'b');

figure
subplot(2,1,1)

G = [0.2298
     0.1172
     0.2462
     1];

SOS = [1   2   1    1   -0.8222    0.7413
       1   2   1    1   -0.9208    0.3895
       1   1   0    1   -0.5076    0];

drawin(2, 10, 'x',2,5,dfont,'b');
drawout(46,10, 'y',0,5,dfont,'b');
% coef1 = num2str(G(4));
% coef1 = '{\its}_3';
% drawmult(46,10,49,' ',coef1,0,5/3,dfont,'b');

section = 1;
c = [G(section) SOS(section,5:6) SOS(section,1:3)];
for ind=1:6; coefs{ind}=num2str(c(ind)); end
% coefs = {'{\its}_1' '{\ita}_{1,2}' '{\ita}_{1,3}' '{\itb}_{1,1}' '{\itb}_{1,2}' '{\itb}_{1,3}'};
drawDF2nd(0,0,4,5,dfont,coefs,'b');

section = 2;
c = [G(section) SOS(section,5:6) SOS(section,1:3)];
for ind=1:6; coefs{ind}=num2str(c(ind)); end
% coefs = {'{\its}_2' '{\ita}_{2,2}' '{\ita}_{2,3}' '{\itb}_{2,1}' '{\itb}_{2,2}' '{\itb}_{2,3}'};
drawDF2nd(16,0,4,5,dfont,coefs,'b');

section = 3;
c = [G(section) SOS(section,5) SOS(section,1:2)];
for ind=1:4; coefs{ind}=num2str(c(ind)); end
% coefs = {'{\its}_2' '{\ita}_{2,2}' '{\ita}_{2,3}' '{\itb}_{2,1}' '{\itb}_{2,2}' '{\itb}_{2,3}'};
drawDF1st(30,0,4,5,dfont,coefs,'b');
