% Example impulse response of a discrete-time system
% Course: Analog and Digital Filter Design
% Lecture: Digital filters, FIR and IIR structures
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/03/11$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

N = 16;
k = 0:(N-1);

b0 = 1;
b1 = -1;
b2 = 2;
B = [b0 b1 b2];

x = (k==0);
y = filter(B,1,x);

subplot(3,1,1)
systemFIR(0,0,4,5,10,'b')

subplot(3,1,2)
stem(k,x,'r')
ylabel('input')

subplot(3,1,3)
stem(k,y,'b')
ylabel('output')
