% {y22num,y22den} = y22FromTransferFunction(num,den)  
% returns numerator and denominator of y22*Ro of a lossless LC 
% Singly Terminated Ladder Realization with Zeros at the Origin. 
% Authors: Dejan V. Tosic, Miroslav D. Lutovac
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/02/20$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

function [y22num, y22den] = y22FromTransferFunction(num, den)

[numEv, numOd] = polynomialEvenOddParts(num);
[denEv, denOd] = polynomialEvenOddParts(den);

if numEv == 0*(1:length(numEv))
  y21num = numOd; y21den = denEv;
  y22num = denOd; y22den = denEv;
else
  y21num = numEv; y21den = denOd;
  y22num = denEv; y22den = denOd;
end
