% [L1, numZ2, denZ2] = extractLinearTerm(num, den, z)
% extracts linear term from impedance num/den 
% Authors: Dejan V. Tosic, Miroslav D. Lutovac
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/02/20$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

function [L1, numZ2, denZ2] = extractLinearTerm(num, den, z)

L1 = polynomialValue(num,z)/(z*polynomialValue(den,z));

numZ2 = num - [den*L1, 0];

denZ2 = den;
