% Example Fourier transform spectrum
% Course: Analog and Digital Filter Design
% Lecture: Review Transforms
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/01/22$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

t1 = -2; t2 = 4; tstep = 0.01;
t = t1:tstep:t2;

x = exp(-t).*(t>0);

subplot(2,2,[1 3]);
plot(t,x,'b');
xlabel('t');
ylabel('x(t)');

w = -10:0.1:10;
f = 1./(1+i*w);

subplot(2,2,2);
plot(w,abs(f));
xlabel('\omega');
ylabel('amplitude spectrum');

subplot(2,2,4);
plot(w,angle(f));
xlabel('\omega');
ylabel('phase spectrum');
