% Example response of discrete-time system by convolution sum
% Course: Analog and Digital Filter Design
% Lecture: Review Systems
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/01/16$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

k = 0:15;
h = ((0.7).^k).*(k>=0);
x = (k>=0) - (k>=4);
c = conv(h,x); 
y = c(1:length(x)); 

subplot(3,1,1); 
stem(k,h,'g'); 
ylabel('h_k','FontSize',14); 
axis([k(1) k(end) -1 2]); 

subplot(3,1,2); 
stem(k,x,'b'); 
ylabel('x_k','FontSize',14); 
axis([k(1) k(end) -1 2]); 

subplot(3,1,3); 
stem(k,y,'r'); 
xlabel('k','FontSize',14); 
ylabel('y_k','FontSize',14); 
axis([k(1) k(end) -1 3]); 
