% Example continuous-time (analog) sinusoidal signal - as inline function
% Course: Analog and Digital Filter Design
% Lecture: Review Signals
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2004 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2004/11/29$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

Xs  = 1.8;
fs = 10; 
phi = pi/3; 

analogSignal = inline('Xs*sin(2*pi*fs*t + phi)', 't', 'Xs', 'fs', 'phi');

t1 = -0.1;
tstep = 0.01;
t2 = 0.2;
timeRange = t1:tstep:t2;

x = analogSignal(timeRange, Xs, fs, phi);

plot(timeRange, x)

xlabel('t')
ylabel('x_s')
title('x_s(t) = X_s sin(2 \pi f_s t + \phi_s)')
grid on