% Example random sequence with uniformly distributed samples
% Course: Analog and Digital Filter Design
% Lecture: Review Signals
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2004 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2004/11/29$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc
set(0,'DefaultLineLineWidth',2)

k = 0:1:50;
x = rand(size(k));
m = mean(x);
s = std(x);

stem(k,x)
hold on
plot([k(1) k(end)],[m m],'r',...
    [k(1) k(end)],[s s],'g')
hold off
set(gca,'FontSize',14)
xlabel('k')
ylabel('x_k')
title('Uniformly distributed samples')
legend('random seq','mean','std')
ytick = [0 s m 1]; set(gca,'YTick',ytick)