% Example digital signal
% Course: Analog and Digital Filter Design
% Lecture: Review Signals
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2004 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2004/11/29$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc
set(0,'DefaultLineLineWidth',2)

t = 0:30;
x = 0.2+2*sin(0.245*t+0.15);
d = 0.5;
xq = d*round(x/d);

plot(t,x)
hold on
stem(t,xq,'r')
hold off
set(gca,'FontSize',14)
ylabel('x(t), x_q(kT)')
xlabel('t')
legend('analog signal',...
       'digital (quantized)')