/*
   Phil's C Course - http://www.pottsoft.demon.co.uk/c_course/course.html

   Example 14         Phil Ottewell 1998 <phil@pottsoft.demon.co.uk>

   Purpose:
            Standard implementation of a function with variable arguments
*/
/*---- Variable Arguments C Example ("vargs.c") ------------------------------*/

/* ANSI C Headers */
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

/* Defines and macros */
#define END 0

/* Function prototypes */
int add_some_ints( int first, ...);

/* Main Program starts here */
int main( int argc, char *argv[] )
{
    int total;
/*  End of declarations ... */

    total = add_some_ints( 1, 2, 3, 4, END);

    printf("Total was %d\n", total );

    exit(EXIT_SUCCESS);
}

/*---- Rather pathetic function to add up some integers ----------------------*/
int add_some_ints( int first, ...)
{
    va_list ap; /* Use to point to each argument in turn */
    int inext, sum, icount;
/*  End of declarations ... */

    icount = 1;
    sum = first;
    va_start( ap, first ); /* Use last named argument - first in this case */

/*  End of args is marked by END, which is zero */

    while ( inext = va_arg( ap, int ) )  {    /* Second arg of va_arg is type */
     sum += inext;
     ++icount;
    }
    va_end( ap ); /* Tidy up */

    printf("add_some_ints added %d integers\n", icount );

    return( sum );
}
