/*
   Phil's C Course - http://www.pottsoft.demon.co.uk/c_course/course.html

   Example 4          Phil Ottewell 1998 <phil@pottsoft.demon.co.uk>

   Purpose:
            Binary tree example demonstrating structure and pointer usage
*/
/*---- Illustration of pointer manipulation ("treesort.c") -------------------*/
/* Example provided by Rob Cannings:                                          */
/* (Excess white space removed by Phil O. ;-))                                */
/* We implement a sorting routine with the sorted list stored in a tree.      */

/* ANSI C Headers */
#include <stdlib.h>
#include <stdio.h>

/* Structures */
struct treeNode {
  int data;
  struct treeNode *pLeft;
  struct treeNode *pRight;
};

/* Function prototypes */
void AddNode(struct treeNode **ppNode,struct treeNode *pNewNode);
void Dump(struct treeNode *pNode);

/* Defines and macros */
#define NUMBER_OF_NUMBERS 4

/* Main Program starts here */
int main(int argc,char *argv[])
{
    int i;
    int toBeSorted[NUMBER_OF_NUMBERS] = { 93, 27, 15, 47};
    struct treeNode dataNode[NUMBER_OF_NUMBERS];
    struct treeNode *pSortedTree;
    struct treeNode *pNewNode;
/*  End of declarations ... */

/*  Initialise one node for each item of data */
    for (i = 0; i < NUMBER_OF_NUMBERS; i++) {
      dataNode[i].pLeft = NULL;
      dataNode[i].pRight = NULL;
      dataNode[i].data = toBeSorted[i];
    }

/*  Build a sorted tree out of the data nodes, printing it */
/*  out after each new node is added to the tree           */
    pSortedTree = NULL; /* the tree starts as just as a stump */

    for (i = 0; i < NUMBER_OF_NUMBERS; i++) {
      pNewNode = &dataNode[i];
      AddNode(&pSortedTree,pNewNode);
      printf("\nSorted list of %d items:\n",i + 1);
      Dump(pSortedTree);
    }
    exit(EXIT_SUCCESS);
}

void AddNode(struct treeNode **ppSortedTree,struct treeNode *pNewNode)
{
    struct treeNode *pCurrentNode;
/*  End of declarations ... */

    pCurrentNode = *ppSortedTree; /* ppSortedTree is a pointer to a pointer */

/*  Have we reached the end of a branch ? */
    if (pCurrentNode == NULL) {
      *ppSortedTree = pNewNode;
    } else {
/*    We have not reached the end of a branch */
      if (pCurrentNode->data > pNewNode->data) {
        AddNode(&(pCurrentNode->pRight),pNewNode);
      } else {
        AddNode(&(pCurrentNode->pLeft),pNewNode);
      }
    }
}

void Dump(struct treeNode *pNode)
{
/*  End of declarations ... */
    if (pNode != NULL) {
      Dump(pNode->pLeft);
      printf("%d\n",pNode->data);
      Dump(pNode->pRight);
    }
}
