/*
   Phil's C Course - http://www.pottsoft.demon.co.uk/c_course/course.html

   Example 2          Phil Ottewell 1998 <phil@pottsoft.demon.co.uk>

   Purpose:
            Demonstrate scope of variable names
*/
/*---- Variable Scope Example ( "scope.c" ) ----------------------------------*/
/* ANSI C Headers */
#include <stdio.h>
#include <stdlib.h>

/* Global variables, visible externally too (i.e. to things linked  */
/* against this) Generally they should be avoided as far as */
/* possible, because it can be very difficult to discover which */
/* routine changes their value, and they introduce "hidden" dependencies */
int some_counter;
double double_result;

/* Function prototypes */
void set_double_result(void);

/* Main Program starts here */
int main( int argc, char *argv[] )
{
    int j;
    int i_am_local; /* .. to main */
/*  End of declarations ... */

    i_am_local = 1;
    printf("i_am_local = %d (in main)\n\n", i_am_local );
    
    for ( j = 0; j < 10; j++ ) {
      int i_am_local; /* .. to this loop - Not necessarily a good idea */
                      /* because it can cause confusion as to which */
                      /* variable we actually want to access */
      i_am_local = j;
      printf("i_am_local = %d (inside loop)\n", i_am_local );
    }

    printf("\ni_am_local = %d (in main)\n\n", i_am_local );

    /* Now let's look at the default initialization values of the globals */
    printf("nsome_counter = %d (in main)\n", some_counter);
    printf("double_result = %f (in main)\n\n", double_result);

    /* Call a function that changes the global variables .. */
    set_double_result(); 

    /* .. and look at them again */
    printf("some_counter = %d (in main)\n", some_counter);
    printf("double_result = %f (in main)\n", double_result);

    exit(EXIT_SUCCESS);
}

void set_double_result(void)
{
    ++some_counter;
    double_result = 3.141;
    printf("some_counter = %d (in set_double_result)\n", some_counter);
    printf("double_result = %f (in set_double_result)\n\n", double_result);
}
