/*
   Phil's C Course - http://www.pottsoft.demon.co.uk/c_course/course.html

   Example 7          Phil Ottewell 1998 <phil@pottsoft.demon.co.uk>

   Purpose:
            Demonstrate file input and output
*/
/*---- File IO Example ("fileio.c") ------------------------------------------*/

/*---- Put all #include files here -------------------------------------------*/
/* ANSI Headers */
#include <ctype.h>    /* Character macros */
#include <errno.h>    /* errno error codes */
#include <stdio.h>    /* Standard I/O */
#include <stdlib.h>   /* Standard Library */
#include <string.h>   /* String Library */
#include <time.h>     /* Time Library */

/*---- Put all #define statements here ---------------------------------------*/
#define PROGRAM_VERSION "1.6"
#define TYPE_OF_FILE "TEST_DATA"
#define NDATA_POINTS 10

/*---- Put all structure definitions here ------------------------------------*/
/* Following structures MUST be packed tightly ie. no member alignment -------*/
#ifdef __DECC
#pragma member_alignment save
# pragma nomember_alignment
#endif

struct file_header_s {
  char type[32];
  char version[8];
  char creator[20];
  time_t time;
};
struct data_s {
  short x;
  short y;
  char name[8];
};

#ifdef __DECC
# pragma member_alignment restore
#endif

int main(int argc, char *argv[])
{
    struct data_s *data_ptr;
    struct file_header_s file_header;
    FILE *outfile, *infile;
    int  i, got_answer;
    char answer[8], yeno[4], node_user[20], filename[128];
    char *c_ptr;
    long int ndata = 0, nitems = 0;
/*  End of declarations ... */

/*  Set up a default namne in case user hasn't specified one */
    if (argc < 2) {
      strcpy(filename,"MYDATA.DAT");
    } else {
      strcpy(filename,argv[1]);
    }

/*  Get node name and user name */
#if !defined( _WIN32 )
    sprintf( node_user, "%s%s", getenv("SYS$NODE"), getenv("USER") ); /* VMS */
#else
    sprintf( node_user,"\\\\%s\\%s",getenv("COMPUTERNAME"),getenv("USERNAME"));
#endif
/*  Convert to uppercase */
    c_ptr = node_user;
    while ( *c_ptr = toupper(*c_ptr) ) ++c_ptr; /* toupper lives in <ctype.h> */

/*  Allocate data space and initialize it */
    data_ptr = (struct data_s *)malloc( sizeof(struct data_s)*NDATA_POINTS );
    if ( data_ptr ) {

      ndata = NDATA_POINTS;
      for ( i = 0; i < ndata; i++) {
        data_ptr[i].x = data_ptr[i].y = i;
        sprintf(data_ptr[i].name, "%3.3d,%3.3d", data_ptr[i].x, data_ptr[i].y );
      }

/*    Open the file for writing in binary mode */
      outfile = fopen(filename,"wb");
      if ( outfile != NULL ) {

/*      Set up the header */
        strcpy(file_header.type,TYPE_OF_FILE);
        strcpy(file_header.version,PROGRAM_VERSION);
        sprintf(file_header.creator,"%s",node_user);
        (void)time(&file_header.time);

        printf("Writing out the header\n");

/*      Items Written   Data Pointer   Size in bytes     No. of items  stream */
/*        |                   |             |                |            |   */
/*        v                   v             v                v            v   */
        nitems = fwrite( &file_header, sizeof(file_header),  1,      outfile);
        if ( ferror(outfile) ) {
          fprintf(stderr,"Error writing file `header':\n%s",strerror(errno));
        }

        printf("Writing out the number of data items, %d\n", ndata);
        nitems = fwrite( &ndata, sizeof(ndata), 1, outfile);
        if ( ferror(outfile) ) {
          fprintf(stderr,"Error writing number of data items:\n%s",
                  strerror(errno));
        }

        printf("Writing out the actual data data all in one chunk\n");
        nitems = fwrite( data_ptr, sizeof(struct data_s)*ndata, 1, outfile);
        if ( ferror(outfile) ) {
          fprintf(stderr,"Error writing data:\n%s",strerror(errno));
        }

        printf("Closing output file\n");
        fclose(outfile);

      } else {
        fprintf(stderr,"Error creating data file %s:\n%s", filename,
                strerror(errno));
      }
    } else {
      fprintf(stderr, "Couldn't allocate space for %d data structures\n",ndata);
    }    

/*  Now optionally read the data back in and format */

    do {
      printf("\nRead data back in ? [Y/N]: ");
      fgets( yeno, sizeof(yeno) , stdin); /* Reads in sizeof(yeno)-1 chars */
      got_answer = sscanf( yeno, "%[YyNnTtFf]", answer);
    } while ( !got_answer );

    if ( answer[0] == 'Y' ||  answer[0] == 'y' ||
         answer[0] == 'T' ||  answer[0] == 't' ) {
      printf( "Here we go ..\n" );

/*    Zero out the structures just to show there's no cheating */
      ndata = 0;
      memset( &file_header, 0 , sizeof( file_header ) );
      memset( data_ptr, 0 , sizeof(struct data_s)*NDATA_POINTS );

/*    Open the file for reading in binary mode */
      infile = fopen(filename,"rb");
      if ( infile != NULL ) {

        printf("Reading in the header\n");
        nitems = fread(&file_header,sizeof(file_header),1,infile);
        if ( ferror(infile) ) {
          fprintf(stderr,"Error reading file `header':\n%s",strerror(errno));
        }

        printf("Header information:  file type %s\n", file_header.type ); 
        printf("                       version %s\n", file_header.version ); 
        printf("                    created by %s\n", file_header.creator ); 
        printf("                            on %s\n", ctime( &file_header.time ) ); 

        nitems = fread( &ndata, sizeof(ndata), 1, infile);
        printf("Read in the number of data items, %d\n", ndata);
        if ( ferror(infile) ) {
          fprintf(stderr,"Error reading number of data items:\n%s",
                  strerror(errno));
        }

        printf("Reading in the actual data data all in one chunk\n");
        nitems = fread( data_ptr, sizeof(struct data_s)*ndata, 1, infile);
        if ( ferror(infile) ) {
          fprintf(stderr,"Error reading data:\n%s",strerror(errno));
        }

        printf("Closing intput file\n\n");
        fclose(infile);

        printf("Read in %d data items\n", ndata);
        for ( i = 0; i < ndata; i++) {
          printf("%3d) x:%3d, y:%3d, Label: %s\n",
                 i, data_ptr[i].x, data_ptr[i].y, data_ptr[i].name );
        }

      } else {
        fprintf(stderr,"Error opening data file %s:\n%s", filename,
                strerror(errno));
      }

    } else {
      printf( "OK - be like that\n" );
    }

    exit(EXIT_SUCCESS);
}
