/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.applet.Applet;
import java.awt.AWTError;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import netscape.security.PrivilegeManager;
import util.ButtonDialog;
import util.Statable;

public class State {
    Applet applet;
    Frame frame;
    String defaultName;
    String stateFileName;
    File stateFile;
    static boolean error = true;
    static final String HEADER = "This is a legal state file";
    private static Hashtable privTable = new Hashtable();

    public State(Applet applet, String defaultName) {
        this.applet = applet;
        this.defaultName = defaultName;
        try {
            Container component = applet;
            while (!(component instanceof Frame)) {
                component = component.getParent();
            }
            this.frame = (Frame)component;
            this.stateFileName = applet.getParameter("stateFile");
            error = false;
            return;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Internal error in State.<init>: got null pointer while looking for frame");
            return;
        }
    }

    public Statable load() {
        if (error || this.stateFileName == null) {
            return null;
        }
        try {
            URL dataURL = new URL(this.applet.getDocumentBase(), this.stateFileName);
            return this.loadFromURL(dataURL, false);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad stateFile parameter in applet tag: \"" + this.stateFileName + "\"");
            error = true;
            return null;
        }
    }

    public Statable loadFromDialog() {
        Statable stateObj = null;
        error = false;
        try {
            File dataFile;
            FileDialog fd = new FileDialog(this.frame, "Pick a data file:", 0);
            if (this.stateFile != null) {
                fd.setDirectory(this.stateFile.getParent());
            }
            ((Window)fd).show();
            if (fd.getFile() != null && (stateObj = this.loadFromFile(dataFile = new File(fd.getDirectory(), fd.getFile()), true)) != null) {
                this.stateFile = dataFile;
            }
        }
        catch (AWTError aWTError) {
            ButtonDialog.showOKDialog(this.applet, null, "Error opening file dialog", "Error opening file dialog:\n(your browser can't do it)");
            error = true;
        }
        catch (SecurityException securityException) {
            ButtonDialog.showOKDialog(this.applet, null, "Error opening file dialog", "Error opening file dialog:\n(your browser won't allow it)");
            error = true;
        }
        return stateObj;
    }

    private Statable loadFromFile(File data, boolean errorDialogs) {
        Statable stateObj = null;
        try {
            if (this.grantedPrivilege("UniversalFileAccess")) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            }
            FileInputStream fis = new FileInputStream(data);
            stateObj = this.loadFromStream(fis, errorDialogs);
            fis.close();
            if (this.grantedPrivilege("UniversalFileAccess")) {
                PrivilegeManager.revertPrivilege((String)"UniversalFileAccess");
            }
            if (stateObj != null) {
                this.stateFile = data;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (errorDialogs) {
                ButtonDialog.showOKDialog(this.applet, null, "Error loading state", "Error loading state: file not found");
            } else {
                System.err.println("Error loading state: file not found");
            }
        }
        catch (IOException e) {
            if (errorDialogs) {
                ButtonDialog.showOKDialog(this.applet, null, "Error loading state", "Error loading state: couldn't read file");
            }
            System.err.println("Error loading state: exception " + e);
            error = true;
        }
        catch (SecurityException securityException) {
            ButtonDialog.showOKDialog(this.applet, null, "Error opening file dialog", "Error opening file dialog:\n(your browser won't allow it)");
            error = true;
        }
        return stateObj;
    }

    private Statable loadFromURL(URL data, boolean errorDialogs) {
        Statable stateObj = null;
        System.out.println("loadFromURL: data=" + data);
        try {
            if (this.grantedPrivilege("UniversalFileAccess")) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            }
            InputStream is = data.openStream();
            stateObj = this.loadFromStream(is, errorDialogs);
            is.close();
            if (this.grantedPrivilege("UniversalFileAccess")) {
                PrivilegeManager.revertPrivilege((String)"UniversalFileAccess");
            }
            this.stateFile = !error && data.getProtocol().equals("file") ? new File(data.getFile()) : null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (errorDialogs) {
                ButtonDialog.showOKDialog(this.applet, null, "Error loading state", "Error loading state: file not found");
            } else {
                System.err.println("Error loading state: file not found");
            }
        }
        catch (IOException e) {
            if (errorDialogs) {
                ButtonDialog.showOKDialog(this.applet, null, "Error loading state", "Error loading state: couldn't read file");
            }
            System.err.println("Error loading state: exception " + e);
            error = true;
        }
        catch (SecurityException e) {
            if (errorDialogs) {
                ButtonDialog.showOKDialog(this.applet, null, "Error loading state", "Error loading state: couldn't read file\n(your browser won't allow it)");
            } else {
                System.err.println("Error loading state: exception " + e);
            }
            error = true;
        }
        return stateObj;
    }

    private Statable loadFromStream(InputStream is, boolean errorDialogs) {
        Statable stateObj = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            DataInputStream dis = new DataInputStream(bis);
            if (dis.readUTF().equals(HEADER)) {
                stateObj = State.stateToObj(dis);
            } else {
                error = true;
            }
            dis.close();
            ((FilterInputStream)bis).close();
            if (this.grantedPrivilege("UniversalFileAccess")) {
                PrivilegeManager.revertPrivilege((String)"UniversalFileAccess");
            }
            if (error) {
                stateObj = null;
                if (errorDialogs) {
                    ButtonDialog.showOKDialog(this.applet, null, "Error loading state", "Error loading state: bad file format");
                } else {
                    System.err.println("Internal error, State.loadFromURL: couldn't restore object");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (errorDialogs) {
                ButtonDialog.showOKDialog(this.applet, null, "Error loading state", "Error loading state: file not found");
            } else {
                System.err.println("Error loading state: file not found");
            }
        }
        catch (IOException e) {
            if (errorDialogs) {
                ButtonDialog.showOKDialog(this.applet, null, "Error loading state", "Error loading state: couldn't read file");
            }
            System.err.println("Error loading state: exception " + e);
            error = true;
        }
        catch (SecurityException e) {
            if (errorDialogs) {
                ButtonDialog.showOKDialog(this.applet, null, "Error loading state", "Error loading state: couldn't read file\n(your browser won't allow it)");
            } else {
                System.err.println("Error loading state: exception " + e);
            }
            error = true;
        }
        return stateObj;
    }

    public boolean canSave() {
        return !error && this.stateFile != null;
    }

    public void clearSave() {
        this.stateFile = null;
    }

    public void save(Statable stateObj) {
        if (this.canSave()) {
            this.saveToFile(stateObj, this.stateFile);
        }
    }

    public void saveAs(Statable stateObj) {
        File newFile = this.saveToDialog(stateObj, this.stateFile, this.defaultName);
        if (newFile != null) {
            this.stateFile = newFile;
        }
    }

    public void saveAsOther(Statable stateObj, String fileName) {
        this.saveToDialog(stateObj, this.stateFile, fileName);
    }

    private File saveToDialog(Statable stateObj, File oldFile, String fileName) {
        File newFile = null;
        error = false;
        try {
            File dataFile;
            FileDialog fd = new FileDialog(this.frame, "Save data as:", 1);
            if (!this.canSave()) {
                fd.setFile(fileName);
            } else if (oldFile != null) {
                fd.setDirectory(oldFile.getParent());
                fd.setFile(oldFile.getName());
            }
            ((Window)fd).show();
            if (fd.getFile() != null && this.saveToFile(stateObj, dataFile = new File(fd.getDirectory(), fd.getFile()))) {
                newFile = dataFile;
            }
        }
        catch (AWTError aWTError) {
            ButtonDialog.showOKDialog(this.applet, null, "Error opening file dialog", "Error opening file dialog:\n(your browser can't do it)");
            error = true;
        }
        catch (SecurityException securityException) {
            ButtonDialog.showOKDialog(this.applet, null, "Error opening file dialog", "Error opening file dialog:\n(your browser won't allow it)");
            error = true;
        }
        return newFile;
    }

    private boolean saveToFile(Statable stateObj, File dataFile) {
        try {
            if (this.grantedPrivilege("UniversalFileAccess")) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            }
            FileOutputStream fos = new FileOutputStream(dataFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(HEADER);
            State.objToState(stateObj, dos);
            dos.close();
            bos.close();
            fos.close();
            stateObj.markClean();
            if (this.grantedPrivilege("UniversalFileAccess")) {
                PrivilegeManager.revertPrivilege((String)"UniversalFileAccess");
            }
        }
        catch (IOException e) {
            ButtonDialog.showOKDialog(this.applet, null, "Error saving state", "Error writing state file:\ncouldn't write to file.");
            System.err.println("Error loading state: exception " + e);
            error = true;
        }
        catch (SecurityException securityException) {
            ButtonDialog.showOKDialog(this.applet, null, "Error saving state", "Error writing state file:\n(your browser won't allow it).");
            error = true;
        }
        return !error;
    }

    public void dispose() {
        this.applet = null;
        this.frame = null;
        this.stateFile = null;
    }

    public static void objToState(Statable obj, DataOutputStream dos) {
        try {
            dos.writeUTF(obj.getClass().getName());
            if (!obj.objIntoState(dos)) {
                error = true;
                return;
            }
        }
        catch (IOException iOException) {
            error = true;
        }
    }

    public static Statable stateToObj(DataInputStream dis) {
        try {
            String name = dis.readUTF();
            Class<?> theClass = Class.forName(name);
            Statable obj = (Statable)theClass.newInstance();
            if (obj.stateIntoObj(dis)) {
                return obj;
            }
            error = true;
            return null;
        }
        catch (IOException iOException) {
            error = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            error = true;
        }
        catch (InstantiationException instantiationException) {
            error = true;
        }
        catch (IllegalAccessException illegalAccessException) {
            error = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            error = true;
        }
        return null;
    }

    public static void postError() {
        error = true;
    }

    private String getSuffix(String string) {
        int pos = string.lastIndexOf(46);
        if (pos == -1) {
            return null;
        }
        return string.substring(pos);
    }

    private String swapSuffix(String string, String suffix) {
        int pos = string.lastIndexOf(46);
        if (pos == -1) {
            return null;
        }
        return string.substring(0, pos) + suffix;
    }

    private boolean grantedPrivilege(String target) {
        Boolean granted = (Boolean)privTable.get(target);
        if (granted == null) {
            try {
                PrivilegeManager.enablePrivilege((String)target);
                granted = Boolean.TRUE;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                granted = Boolean.FALSE;
            }
            catch (Exception exception) {
                granted = Boolean.FALSE;
            }
            privTable.put(target, granted);
        }
        return granted;
    }
}

