/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import util.QueueEnumerator;
import util.QueueLink;

public class Queue {
    protected QueueLink theHead = null;
    protected QueueLink theTail = null;
    protected int elementCount = 0;

    public synchronized void addElement(Object elt) {
        QueueLink link = new QueueLink();
        link.elt = elt;
        link.next = null;
        if (this.theTail != null) {
            this.theTail.next = link;
        }
        this.theTail = link;
        if (this.theHead == null) {
            this.theHead = link;
        }
        ++this.elementCount;
    }

    public final synchronized Object removeElement() throws NoSuchElementException {
        if (this.theHead == null) {
            throw new NoSuchElementException("Queue");
        }
        Object elt = this.theHead.elt;
        this.theHead = this.theHead.next;
        --this.elementCount;
        if (this.theHead == null) {
            this.theTail = null;
        }
        return elt;
    }

    public final synchronized Object removeElement(Object elt) throws NoSuchElementException {
        QueueLink link = this.theHead;
        QueueLink prevLink = null;
        while (link != null) {
            if (link.elt == elt) {
                if (prevLink == null) {
                    if (link == this.theTail) {
                        this.theHead = null;
                        this.theTail = null;
                    } else {
                        this.theHead = link.next;
                    }
                } else if (link == this.theTail) {
                    this.theTail = prevLink;
                    prevLink.next = null;
                } else {
                    prevLink.next = link.next;
                }
                link.elt = null;
                link.next = null;
                --this.elementCount;
                return elt;
            }
            prevLink = link;
            link = link.next;
        }
        throw new NoSuchElementException();
    }

    public synchronized boolean contains(Object elt) {
        QueueLink link = this.theHead;
        while (link != null) {
            if (link.elt == elt) {
                return true;
            }
            link = link.next;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        while (this.theHead != null) {
            QueueLink link = this.theHead;
            this.theHead = this.theHead.next;
            link.elt = null;
            link.next = null;
        }
        this.theTail = null;
        this.elementCount = 0;
    }

    public final Object peekElement() throws NoSuchElementException {
        if (this.theHead == null) {
            throw new NoSuchElementException("Queue");
        }
        return this.theHead.elt;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final synchronized Enumeration elements() {
        return new QueueEnumerator(this);
    }

    public synchronized Object clone() {
        Queue q = new Queue();
        QueueLink link = this.theHead;
        while (link != null) {
            q.addElement(link.elt);
            link = link.next;
        }
        return q;
    }

    public final synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            String s = e.nextElement().toString();
            buf.append(s);
            if (!e.hasMoreElements()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void dispose() {
        this.removeAllElements();
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

