/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.Queue;

public class Loader
implements Runnable {
    static final int THREADS = 5;
    Thread[] threads = new Thread[5];
    Queue[] queues = new Queue[5];
    boolean[] loading = new boolean[5];
    int next;

    public Loader() {
        int i = 0;
        while (i < 5) {
            this.threads[i] = new Thread((Runnable)this, "Loader " + i);
            this.queues[i] = new Queue();
            this.loading[i] = false;
            this.threads[i].start();
            ++i;
        }
    }

    public Loader(String[] classes) {
        this();
        int i = 0;
        while (i < classes.length) {
            this.load(classes[i]);
            ++i;
        }
    }

    public void load(String theClass) {
        Queue queue = this.queues[this.next];
        synchronized (queue) {
            this.queues[this.next].addElement(theClass);
            this.queues[this.next].notifyAll();
        }
        if (++this.next == 5) {
            this.next = 0;
        }
    }

    public void load(String[] classes) {
        int i = 0;
        while (i < classes.length) {
            this.load(classes[i]);
            ++i;
        }
    }

    public boolean allLoaded() {
        int x = 0;
        while (x < 5) {
            if (this.queues[x] != null) {
                if (!this.queues[x].isEmpty()) {
                    return false;
                }
                if (this.loading[x]) {
                    return false;
                }
            }
            ++x;
        }
        return true;
    }

    public void waitLoaded() {
        boolean done = false;
        while (!done) {
            Loader loader = this;
            synchronized (loader) {
                if (this.allLoaded()) {
                    done = true;
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public void run() {
        int num = -1;
        int i = 0;
        while (i < 5) {
            if (this.threads[i] == Thread.currentThread()) {
                num = i;
            }
            ++i;
        }
        if (num == -1) {
            System.err.println("Loader.run: error, couldn't find thread");
        }
        Queue queue = this.queues[num];
        while (true) {
            Object object;
            if (!queue.isEmpty()) {
                this.loading[num] = true;
                this.loadNow((String)queue.removeElement(), num);
                this.loading[num] = false;
                object = this;
                synchronized (object) {
                    if (queue.isEmpty()) {
                        this.notifyAll();
                    }
                }
            }
            object = queue;
            synchronized (object) {
                if (queue.isEmpty()) {
                    try {
                        queue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private void loadNow(String theClass, int num) {
        try {
            Class.forName(theClass);
            return;
        }
        catch (ClassNotFoundException e) {
            System.err.println("Loader.loadNow: couldn't load class " + theClass + ";" + e);
            return;
        }
    }

    public void dispose() {
        int i;
        if (this.threads != null) {
            i = 0;
            while (i < 5) {
                this.threads[i].stop();
                ++i;
            }
            this.threads = null;
        }
        if (this.queues != null) {
            i = 0;
            while (i < 5) {
                this.queues[i].dispose();
                ++i;
            }
            this.queues = null;
        }
    }
}

