/*
 * Decompiled with CFR 0.152.
 */
package util;

public class CPUTools {
    static String error;
    public static final int OPCODE_ADD = 0;
    public static final int OPCODE_SUB = 1;
    public static final int OPCODE_MUL = 2;
    public static final int OPCODE_DIV = 3;
    public static final int OPCODE_LOD = 4;
    public static final int OPCODE_STO = 5;
    public static final int OPCODE_AND = 8;
    public static final int OPCODE_NOT = 9;
    public static final int OPCODE_CPZ = 10;
    public static final int OPCODE_CPL = 11;
    public static final int OPCODE_JMP = 12;
    public static final int OPCODE_JMZ = 13;
    public static final int OPCODE_NOP = 14;
    public static final int OPCODE_HLT = 15;
    public static final int IMMEDIATE_FLAG = 16;
    public static final String[] VARIABLES;
    public static final int VARIABLE_BASE = 128;
    static final String SEPARATOR = "\t";

    private CPUTools() {
    }

    public static boolean isImmediate(String operand) {
        return operand.charAt(0) == '#';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int instructionToInt16(String instruction) {
        error = null;
        String opcodeString = CPUTools.firstPart(instruction);
        String operandString = CPUTools.secondPart(instruction);
        int opcode = CPUTools.opcodeToInt8(opcodeString);
        if (error != null) {
            return -1;
        }
        int operand = 0;
        if (CPUTools.opcodeTakesNoOperand(opcode) && operandString != null) {
            error = "opcode does not take an operand";
            return -1;
        }
        if (!CPUTools.opcodeTakesNoOperand(opcode) && operandString == null) {
            error = "opcode requires an operand";
            return -1;
        }
        if (CPUTools.opcodeTakesNoOperand(opcode)) {
            return CPUTools.joinBits(opcode, operand);
        }
        if (CPUTools.isImmediate(operandString)) {
            operand = CPUTools.operandImmediateToInt(operandString);
            if (error != null) {
                return -1;
            }
            opcode += 16;
            return CPUTools.joinBits(opcode, operand);
        } else if (opcode == 12 || opcode == 13) {
            try {
                operand = Integer.parseInt(operandString, 10);
                if (operand >= -128 && operand <= 127) return CPUTools.joinBits(opcode, operand);
                error = "operand out of range";
                System.err.println("CPU.operandImmediate: value out of range " + operand);
                return CPUTools.joinBits(opcode, operand);
            }
            catch (NumberFormatException numberFormatException) {
                error = "operand not a legal integer";
                return -1;
            }
        } else {
            operand = CPUTools.operandDirectToInt(operandString);
            if (error == null) return CPUTools.joinBits(opcode, operand);
            return -1;
        }
    }

    public static String int16ToInstruction(int instruction) {
        String operString;
        boolean imm = false;
        error = null;
        int opcode = CPUTools.top8Bits(instruction);
        int operand = CPUTools.bottom8Bits(instruction);
        if (opcode >= 16) {
            imm = true;
            opcode -= 16;
        }
        String opString = new String(CPUTools.opcodeToString(opcode));
        if (CPUTools.opcodeTakesNoOperand(opcode)) {
            return opString;
        }
        if (imm) {
            operString = new String(CPUTools.operandImmediateToString(operand));
        } else if (opcode == 12 || opcode == 13) {
            Integer i = new Integer(operand);
            operString = i.toString();
        } else {
            operString = new String(CPUTools.operandDirectToString(operand));
        }
        if (opString.length() > 0) {
            return opString + SEPARATOR + operString;
        }
        error = "unknown opcode";
        return null;
    }

    public static String int16ToOpcode(int instruction) {
        int top = CPUTools.top8Bits(instruction);
        if (top >= 16) {
            top -= 16;
        }
        return CPUTools.opcodeToString(top);
    }

    public static String int16ToOperand(int instruction) {
        int opcode = CPUTools.top8Bits(instruction);
        int operand = CPUTools.bottom8Bits(instruction);
        if (opcode >= 16) {
            return CPUTools.operandImmediateToString(operand);
        }
        if (opcode == 12 || opcode == 13) {
            Integer i = new Integer(operand);
            return i.toString();
        }
        if (operand == 0) {
            return "";
        }
        return CPUTools.operandDirectToString(operand);
    }

    public static boolean opcodeTakesNoOperand(int opcode) {
        return opcode == 9 || opcode == 14 || opcode == 15;
    }

    public static char opcodeToOperation(int opcode) {
        switch (opcode) {
            case 0: {
                return '+';
            }
            case 1: {
                return '-';
            }
            case 2: {
                return '*';
            }
            case 3: {
                return '/';
            }
            case 4: {
                return '=';
            }
            case 8: {
                return '^';
            }
            case 10: {
                return ':';
            }
            case 11: {
                return '<';
            }
            case 9: {
                return '!';
            }
        }
        return ' ';
    }

    public static String intToBinString(int value, int digits) {
        String binString = Integer.toString(value, 2);
        return "0000000000000000".substring(binString.length(), digits) + binString;
    }

    public static String sEx8ToBinString(int value) {
        return CPUTools.intToBinString(value & 0xFF, 8);
    }

    public static String sEx8ToDecString(int value) {
        return Integer.toString(CPUTools.intToSEx8(value), 10);
    }

    public static int intToSEx8(int value) {
        if ((value & 0x80) == 128) {
            return value | 0xFFFFFF00;
        }
        return value & 0xFF;
    }

    public static int stringToSEx8(String value, int base) throws NumberFormatException {
        int i = Integer.valueOf(value, base);
        if (base == 2 && i >= 128 && i <= 255) {
            i |= 0xFFFFFF00;
        }
        return i;
    }

    public static int top8Bits(int value) {
        return value / 256;
    }

    public static int bottom8Bits(int value) {
        return value % 256;
    }

    public static String error() {
        return error;
    }

    private static int opcodeToInt8(String opcode) {
        opcode = opcode.toUpperCase();
        error = null;
        if (opcode.equals("ADD")) {
            return 0;
        }
        if (opcode.equals("SUB")) {
            return 1;
        }
        if (opcode.equals("MUL")) {
            return 2;
        }
        if (opcode.equals("DIV")) {
            return 3;
        }
        if (opcode.equals("LOD")) {
            return 4;
        }
        if (opcode.equals("STO")) {
            return 5;
        }
        if (opcode.equals("AND")) {
            return 8;
        }
        if (opcode.equals("NOT")) {
            return 9;
        }
        if (opcode.equals("CPZ")) {
            return 10;
        }
        if (opcode.equals("CPL")) {
            return 11;
        }
        if (opcode.equals("JMP")) {
            return 12;
        }
        if (opcode.equals("JMZ")) {
            return 13;
        }
        if (opcode.equals("NOP")) {
            return 14;
        }
        if (opcode.equals("HLT")) {
            return 15;
        }
        error = "unknown instruction";
        return -1;
    }

    private static String opcodeToString(int opcode) {
        switch (opcode) {
            case 0: {
                return "ADD";
            }
            case 1: {
                return "SUB";
            }
            case 2: {
                return "MUL";
            }
            case 3: {
                return "DIV";
            }
            case 4: {
                return "LOD";
            }
            case 5: {
                return "STO";
            }
            case 8: {
                return "AND";
            }
            case 9: {
                return "NOT";
            }
            case 10: {
                return "CPZ";
            }
            case 11: {
                return "CPL";
            }
            case 12: {
                return "JMP";
            }
            case 13: {
                return "JMZ";
            }
            case 14: {
                return "NOP";
            }
            case 15: {
                return "HLT";
            }
        }
        return "";
    }

    private static int operandDirectToInt(String operand) {
        if (operand == null) {
            error = "opcode requires an operand";
            return 0;
        }
        if (operand.charAt(0) == '#') {
            error = "opcode requires a direct reference";
            return 0;
        }
        int i = 0;
        while (i < VARIABLES.length) {
            if (VARIABLES[i].equals(operand)) {
                return i + 128;
            }
            ++i;
        }
        error = "unknown variable";
        return 0;
    }

    private static String operandDirectToString(int operand) {
        if (operand >= 128 && operand - 128 < VARIABLES.length) {
            return VARIABLES[operand - 128];
        }
        error = "unknown variable";
        return null;
    }

    private static int operandImmediateToInt(String operand) {
        if (operand == null) {
            error = "opcode requires an operand";
            return 0;
        }
        if (operand.charAt(0) != '#') {
            error = "opcode requires an immediate value";
            return 0;
        }
        String value = operand.substring(1);
        try {
            int integer = Integer.parseInt(value, 10);
            if (integer < -128 || integer > 127) {
                error = "operand out of range";
                System.err.println("CPU.operandImmediate: value out of range " + integer);
                return 0;
            }
            return integer;
        }
        catch (NumberFormatException numberFormatException) {
            error = "operand not a legal integer";
            return 0;
        }
    }

    private static String operandImmediateToString(int operand) {
        return "#" + Integer.toString(CPUTools.intToSEx8(operand));
    }

    private static String firstPart(String string) {
        int startPos = 0;
        while (startPos < string.length() && (string.charAt(startPos) == ' ' || string.charAt(startPos) == '\t')) {
            ++startPos;
        }
        int endPos = startPos;
        while (endPos < string.length() && string.charAt(endPos) != ' ' && string.charAt(endPos) != '\t') {
            ++endPos;
        }
        String result = string.substring(startPos, endPos);
        return result;
    }

    private static String secondPart(String string) {
        int startPos = 0;
        while (startPos < string.length() && (string.charAt(startPos) == ' ' || string.charAt(startPos) == '\t')) {
            ++startPos;
        }
        while (startPos < string.length() && string.charAt(startPos) != ' ' && string.charAt(startPos) != '\t') {
            ++startPos;
        }
        while (startPos < string.length() && (string.charAt(startPos) == ' ' || string.charAt(startPos) == '\t')) {
            ++startPos;
        }
        int endPos = startPos;
        while (endPos < string.length() && string.charAt(endPos) != ' ' && string.charAt(endPos) != '\t') {
            ++endPos;
        }
        if (startPos == endPos) {
            return null;
        }
        String result = string.substring(startPos, endPos);
        return result;
    }

    private static int joinBits(int top8Bits, int bottom8Bits) {
        return (top8Bits << 8 & 0xFF00) + (bottom8Bits & 0xFF);
    }

    static {
        VARIABLES = new String[]{"W", "X", "Y", "Z", "T1", "T2", "T3", "T4"};
    }
}

