/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import util.MultiLineLabel;

public class ButtonDialog
extends Dialog {
    Button[] buttons;
    MultiLineLabel label;
    int result = -2;
    static final Font font = new Font("Dialog", 0, 12);
    static final String[] okList = new String[]{"OK"};
    Component owner;

    public static Frame getParent(Component component) {
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    public static void showOKDialog(Component owner, String title, String message) {
        Frame frame = ButtonDialog.getParent(owner);
        ButtonDialog dialog = new ButtonDialog(frame, owner, title, message, okList);
        dialog.show();
    }

    public static void showOKDialog(Component frame, Component owner, String title, String message) {
        Frame realFrame = ButtonDialog.getParent(frame);
        ButtonDialog dialog = new ButtonDialog(realFrame, owner, title, message, okList);
        dialog.show();
    }

    public ButtonDialog(Frame frame, Component owner, String title, String message, String[] buttonLabels) {
        super(frame, title, true);
        this.owner = owner;
        ((Component)this).setFont(font);
        this.setResizable(false);
        this.setLayout(new BorderLayout(25, 25));
        this.label = new MultiLineLabel(message, 20, 20);
        this.add("Center", this.label);
        Panel p = new Panel();
        p.setLayout(new FlowLayout(buttonLabels.length == 1 ? 2 : 1, 15, 15));
        this.buttons = new Button[buttonLabels.length];
        int i = 0;
        while (i < buttonLabels.length) {
            this.buttons[i] = new Button(buttonLabels[i]);
            p.add("South", this.buttons[i]);
            ++i;
        }
        this.add("South", p);
        this.pack();
    }

    public synchronized void show() {
        Dimension dimScreen = this.getToolkit().getScreenSize();
        this.move((dimScreen.width - this.size().width) / 2, (dimScreen.height - this.size().height) / 3);
        super.show();
    }

    public boolean handleEvent(Event evt) {
        if (evt.id == 201) {
            this.postResult(-1);
            return true;
        }
        return super.handleEvent(evt);
    }

    public boolean keyDown(Event evt, int key) {
        if ((key == 10 || key == 13) && this.buttons.length == 1) {
            this.postResult(0);
            return true;
        }
        return false;
    }

    public boolean action(Event e, Object arg) {
        if (e.target instanceof Button) {
            int i = 0;
            while (i < this.buttons.length) {
                if (e.target == this.buttons[i]) {
                    this.postResult(i);
                    return true;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int result() {
        return this.result;
    }

    public synchronized void postResult(int result) {
        this.result = result;
        this.notify();
        ((Component)this).hide();
        this.dispose();
        if (this.owner != null) {
            this.owner.requestFocus();
        }
    }
}

