/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import screen.Stage;
import util.ColorTools;

public class TextBox {
    int x;
    int y;
    int width;
    int height;
    long textTime;
    long bgTime;
    Font font;
    static final int COLOR_COUNT = 10;
    Color[] textColors;
    Color[] bgColors;
    String symText;
    String binText;
    String symTabText;
    String binTabText;
    boolean calcOffsets = true;
    static final int MARGIN = 5;
    static final int TAB_MARGIN = 40;
    boolean dirty = true;
    int symXOffset;
    int binXOffset;
    int yOffset;
    boolean frame;
    boolean centered;
    Stage stage;

    public TextBox(Stage stage, int x, int y, int width, int height, String symText, String binText, Font font, boolean frame, boolean centered) {
        this.stage = stage;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setText(symText, binText);
        this.font = font;
        this.frame = frame;
        this.centered = centered;
        this.setTextColors(Color.red, Color.black);
        this.setBGColors(Color.green, new Color(224, 224, 224));
    }

    public void setTextColors(Color activeColor, Color idleColor) {
        this.textColors = ColorTools.interpArrayRGB(activeColor, idleColor, 10);
    }

    public void setTextColors(Color[] textColors) {
        this.textColors = textColors;
    }

    public void setBGColors(Color activeColor, Color idleColor) {
        this.bgColors = ColorTools.interpArrayRGB(activeColor, idleColor, 10);
    }

    public void setBGColors(Color[] bgColors) {
        this.bgColors = bgColors;
    }

    public void dumpColors() {
        int i = 0;
        while (i < this.bgColors.length) {
            System.out.println("Color " + i + " = " + this.bgColors[i]);
            ++i;
        }
    }

    public void reshape(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.calcOffsets = true;
        this.dirty = true;
    }

    public Rectangle getRect() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public boolean inside(int x, int y) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    public void setText(String symText, String binText) {
        int tabPos = symText.indexOf(9);
        if (tabPos == -1) {
            this.symText = symText;
            this.symTabText = "";
        } else {
            this.symText = symText.substring(0, tabPos);
            this.symTabText = symText.substring(tabPos + 1);
        }
        tabPos = binText.indexOf(9);
        if (tabPos == -1) {
            this.binText = binText;
            this.binTabText = "";
        } else {
            this.binText = binText.substring(0, tabPos);
            this.binTabText = binText.substring(tabPos + 1);
        }
        this.calcOffsets = true;
        this.dirty = true;
    }

    public void flashText() {
        this.textTime = System.currentTimeMillis();
        this.dirty = true;
    }

    public void flashBG() {
        this.bgTime = System.currentTimeMillis();
        this.dirty = true;
    }

    public boolean drawAll(Graphics g) {
        this.dirty = false;
        if (this.calcOffsets) {
            FontMetrics fm = g.getFontMetrics(this.font);
            if (this.centered) {
                this.symXOffset = (this.width - fm.stringWidth(this.symText)) / 2;
                this.binXOffset = (this.width - fm.stringWidth(this.binText)) / 2;
            } else {
                this.symXOffset = 5;
                this.binXOffset = 5;
            }
            this.yOffset = this.height - (this.height - (fm.getAscent() - (1 + this.font.getSize() / 12))) / 2;
            this.calcOffsets = false;
        }
        this.dirty |= ColorTools.setColor(g, this.bgColors, this.bgTime);
        g.fillRect(this.x, this.y, this.width, this.height);
        if (this.frame) {
            g.setColor(Color.black);
            g.drawRect(this.x, this.y, this.width, this.height);
        }
        this.dirty |= ColorTools.setColor(g, this.textColors, this.textTime);
        g.setFont(this.font);
        if (this.stage.getMode() == 1) {
            g.drawString(this.symText, this.x + this.symXOffset, this.y + this.yOffset);
            g.drawString(this.symTabText, this.x + 40, this.y + this.yOffset);
        } else {
            g.drawString(this.binText, this.x + this.binXOffset, this.y + this.yOffset);
            g.drawString(this.binTabText, this.x + 40, this.y + this.yOffset);
        }
        return this.dirty;
    }

    public boolean drawNew(Graphics g) {
        if (this.dirty) {
            return this.drawAll(g);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

