/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import screen.Node;
import screen.Sprite;
import util.FFCanvas;
import util.Global;

public class Stage
extends FFCanvas
implements Runnable {
    Vector sprites = new Vector();
    Color bgColor;
    public Global mode;
    int lastMode = -1;
    boolean aborting = false;
    Vector nodes = new Vector(30);
    Thread thread;
    boolean running = true;
    boolean dirty = false;

    public Stage(Color bg, Dimension stageSize, Global mode) {
        this.mode = mode;
        this.setBackground(bg);
        this.bgColor = bg;
        this.resize(stageSize);
        this.thread = new Thread((Runnable)this, "StageRepainter");
        this.thread.start();
    }

    public void run() {
        while (this.running) {
            if (this.dirty) {
                this.update(null);
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void startRepaint() {
        this.dirty = true;
    }

    public int getMode() {
        return this.mode.getInt();
    }

    public void setMode(int mode) {
        this.mode.setInt(mode);
    }

    public void aborting(boolean aborting) {
        this.aborting = aborting;
    }

    public boolean aborting() {
        return this.aborting;
    }

    public Dimension minimumSize() {
        return this.size();
    }

    public Dimension preferredSize() {
        return this.size();
    }

    public synchronized void addSprite(Sprite theSprite, int theChannel) {
        Vector<Sprite> vector;
        if (theSprite.stage == null) {
            System.out.println("Stage.addSprite with sprite.stage == null!");
        }
        if (this.sprites.size() <= theChannel) {
            this.sprites.setSize(theChannel + 1);
        }
        if (this.sprites.elementAt(theChannel) == null) {
            vector = new Vector<Sprite>();
            this.sprites.setElementAt(vector, theChannel);
        } else {
            vector = (Vector<Sprite>)this.sprites.elementAt(theChannel);
        }
        if (vector.contains(theSprite)) {
            System.out.println("Stage.addSprite: the sprite is already there!");
        }
        vector.addElement(theSprite);
        this.startRepaint();
    }

    public void removeSprite(Sprite theSprite) {
        Enumeration e = this.sprites.elements();
        while (e.hasMoreElements()) {
            Vector v = (Vector)e.nextElement();
            if (v == null || !v.removeElement(theSprite)) continue;
            this.markDirty();
            return;
        }
        System.err.println("Stage.removeSprite: couldn't find sprite " + theSprite);
    }

    public void removeSprites(int theChannel) {
        if (theChannel < this.sprites.size()) {
            this.sprites.setElementAt(null, theChannel);
            this.markDirty();
        }
    }

    public void removeAllSprites() {
        int theChannel = 0;
        while (theChannel < this.sprites.size()) {
            this.removeSprites(theChannel);
            ++theChannel;
        }
    }

    public synchronized void addNode(Node node) {
        this.nodes.addElement(node);
    }

    public Node nodeByName(String name) {
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            Node node = (Node)e.nextElement();
            if (!node.name.equals(name)) continue;
            return node;
        }
        System.err.println("Node.getNode: couldn't find node \"" + name + "\"");
        Enumeration e2 = this.nodes.elements();
        while (e2.hasMoreElements()) {
            System.err.println(" (item in list: " + (Node)e2.nextElement() + ")");
        }
        return null;
    }

    public Sprite locateSprite(int x, int y) {
        int i = 0;
        while (i < this.sprites.size()) {
            Vector v = (Vector)this.sprites.elementAt(i);
            if (v != null) {
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    Sprite s = (Sprite)e.nextElement();
                    if (!s.inside(x, y)) continue;
                    return s;
                }
            }
            ++i;
        }
        return null;
    }

    public void dirtySprite(Sprite sprite) {
        this.startRepaint();
    }

    public void markDirty() {
        this.lastMode = -1;
        this.startRepaint();
    }

    public void paintAll(Graphics g) {
        boolean redraw = false;
        System.currentTimeMillis();
        g.setColor(this.bgColor);
        g.setPaintMode();
        Dimension d = this.size();
        g.fillRect(0, 0, d.width, d.height);
        Stage stage = this;
        synchronized (stage) {
            Enumeration e1 = this.sprites.elements();
            while (e1.hasMoreElements()) {
                Vector v = (Vector)e1.nextElement();
                if (v == null) continue;
                Enumeration e2 = v.elements();
                while (e2.hasMoreElements()) {
                    redraw |= ((Sprite)e2.nextElement()).drawAll(g);
                }
            }
        }
        if (!redraw) {
            this.dirty = false;
        }
    }

    public void paintNew(Graphics g) {
        boolean redraw = false;
        boolean newMode = this.getMode() != this.lastMode;
        this.lastMode = this.getMode();
        System.currentTimeMillis();
        Stage stage = this;
        synchronized (stage) {
            Enumeration e1 = this.sprites.elements();
            while (e1.hasMoreElements()) {
                Vector v = (Vector)e1.nextElement();
                if (v == null) continue;
                Enumeration e2 = v.elements();
                while (e2.hasMoreElements()) {
                    if (newMode) {
                        redraw |= ((Sprite)e2.nextElement()).drawAll(g);
                        continue;
                    }
                    Sprite s = (Sprite)e2.nextElement();
                    boolean thisRedraw = s.drawNew(g);
                    redraw |= thisRedraw;
                }
            }
        }
        if (!redraw) {
            this.dirty = false;
        }
    }

    public void dispose() {
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName() + "[sprites=[");
        buf.append("],bgColor=" + this.bgColor);
        return buf.toString();
    }
}

