/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import screen.AbortedException;
import screen.Node;
import screen.Sprite;
import screen.Stage;
import util.ColorTools;

public class SpriteWire
extends Sprite {
    Node start;
    Node end;
    int[] xList;
    int[] yList;
    long[] timeList;
    int count;
    boolean horizontal;
    static final int SEG_LENGTH = 15;
    static final int COLOR_COUNT = 10;
    static final int COLOR_TIME = 100;
    static final int SEG_TIME = 100;
    static Color[] colors = ColorTools.interpArrayHSB(Color.green, new Color(128, 0, 0), 10);

    public SpriteWire(Stage stage, Node start, Node end) {
        super(stage, new Point(0, 0));
        this.start = start;
        start.addWire(this);
        this.end = end;
        end.addWire(this);
        Point startPoint = start.location();
        Point endPoint = end.location();
        float distX = endPoint.x - startPoint.x;
        float distY = endPoint.y - startPoint.y;
        float dist = (float)Math.sqrt(distX * distX + distY * distY);
        this.count = (int)(dist / 15.0f);
        if (this.count == 0) {
            this.count = 1;
        }
        this.horizontal = distX != 0.0f;
        float x = startPoint.x;
        float y = startPoint.y;
        float diffX = distX / (float)this.count;
        float diffY = distY / (float)this.count;
        this.xList = new int[this.count + 1];
        this.yList = new int[this.count + 1];
        this.timeList = new long[this.count];
        int i = 0;
        while (i < this.count) {
            this.xList[i] = (int)x;
            this.yList[i] = (int)y;
            this.timeList[i] = 0L;
            x += diffX;
            y += diffY;
            ++i;
        }
        this.xList[i] = (int)x;
        this.yList[i] = (int)y;
    }

    public void addStage(int theChannel) {
        super.addStage(theChannel);
        this.stage.addNode(this.start);
        this.stage.addNode(this.end);
    }

    public boolean inside(int x, int y) {
        return false;
    }

    public void mouseHandle(Event event) {
    }

    public boolean animateFrom(Node goal) throws AbortedException {
        Node node = this.start;
        boolean wasStart = true;
        int i = 0;
        while (i < 2) {
            if (node.animateFrom(goal)) {
                long nextTime = System.currentTimeMillis();
                int j = 0;
                while (j < this.count) {
                    if (this.stage.aborting()) {
                        throw new AbortedException();
                    }
                    this.timeList[wasStart ? j : this.count - 1 - j] = nextTime;
                    this.markDirty();
                    long waitTime = (nextTime += 100L) - System.currentTimeMillis();
                    if (waitTime > 0L) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(waitTime);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    ++j;
                }
                return true;
            }
            node = this.end;
            wasStart = false;
            ++i;
        }
        return false;
    }

    public boolean drawAll(Graphics g) {
        boolean wasDirty = this.dirty;
        this.markClean();
        g.setPaintMode();
        if (wasDirty) {
            int startX = this.xList[0];
            int startY = this.yList[0];
            System.currentTimeMillis();
            int i = 0;
            while (i < this.timeList.length) {
                int endX = this.xList[i + 1];
                int endY = this.yList[i + 1];
                this.dirty |= ColorTools.setColor(g, colors, this.timeList[i]);
                if (this.horizontal) {
                    g.drawLine(startX, startY - 1, endX, endY - 1);
                    g.drawLine(startX, startY, endX, endY);
                    g.drawLine(startX, startY + 1, endX, endY + 1);
                } else {
                    g.drawLine(startX - 1, startY, endX - 1, endY);
                    g.drawLine(startX, startY, endX, endY);
                    g.drawLine(startX + 1, startY, endX + 1, endY);
                }
                startX = endX;
                startY = endY;
                ++i;
            }
        } else {
            g.setColor(colors[colors.length - 1]);
            int startX = this.xList[0];
            int startY = this.yList[0];
            int endX = this.xList[this.timeList.length - 1];
            int endY = this.yList[this.timeList.length - 1];
            if (this.horizontal) {
                g.drawLine(startX, startY - 1, endX, endY - 1);
                g.drawLine(startX, startY, endX, endY);
                g.drawLine(startX, startY + 1, endX, endY + 1);
            } else {
                g.drawLine(startX - 1, startY, endX - 1, endY);
                g.drawLine(startX, startY, endX, endY);
                g.drawLine(startX + 1, startY, endX + 1, endY);
            }
        }
        if (this.dirtyPartner != null) {
            this.dirtyPartner.drawAll(g);
        }
        return this.dirty;
    }

    public synchronized void dispose() {
        if (this.start != null) {
            this.start = null;
            this.end = null;
        }
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public String toString() {
        return this.getClass().getName() + "[start=" + this.start + ",end=" + this.end + "]";
    }
}

