/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Font;
import java.awt.Rectangle;
import screen.SpriteComponent;
import screen.Stage;
import screen.TextBox;

public abstract class SpriteRAM
extends SpriteComponent {
    static final int VARIABLE_BASE = 128;
    TextBox[] addBoxes;
    TextBox[] datBoxes;
    int[] data;
    Font font = new Font("Helvetica", 0, 12);
    static final float ADD_FRAC = 0.33333334f;
    static final int HEIGHT = 8;

    public SpriteRAM(Stage stage, String name, int x, int y, int width, int height) {
        super(stage, name, x, y, width, height);
    }

    public int getValue(int address) {
        int index = this.addressToIndex(address);
        return this.data[index];
    }

    public abstract String getStringValue(int var1);

    public abstract String checkValue(int var1, String var2);

    public abstract String checkValue(int var1, int var2);

    public abstract void setValue(int var1, String var2);

    public abstract void setValue(int var1, int var2);

    public abstract int firstAddress();

    public abstract int lastAddress();

    public abstract int nextAddress(int var1);

    public abstract int prevAddress(int var1);

    public abstract boolean showAddress(int var1);

    public void flashAddress(int address) {
        int index = this.addressToIndex(address);
        this.addBoxes[index].flashBG();
        this.markDirty();
    }

    public void flashData(int address) {
        int index = this.addressToIndex(address);
        this.datBoxes[index].flashBG();
        this.markDirty();
    }

    public int clickToAddress(int x, int y) {
        int i = 0;
        while (i < this.datBoxes.length) {
            if (this.datBoxes[i].inside(x, y)) {
                return this.indexToAddress(i);
            }
            ++i;
        }
        return -1;
    }

    public Rectangle addressToRect(int address) {
        int index = this.addressToIndex(address);
        return this.datBoxes[index].getRect();
    }

    protected abstract int addressToIndex(int var1);

    protected abstract int indexToAddress(int var1);
}

