/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Scrollbar;
import screen.SpriteRAM;
import screen.Stage;
import screen.TextBox;
import util.CPUTools;

public class SpriteIRAM
extends SpriteRAM {
    int scroll;
    Scrollbar scrollBar;
    static Color[] addColors = new Color[]{new Color(0, 255, 0), new Color(0, 255, 0), new Color(0, 255, 0), new Color(0, 255, 0), new Color(0, 255, 0), new Color(204, 204, 153), new Color(204, 204, 153), new Color(204, 204, 153), new Color(204, 204, 153), new Color(255, 204, 204)};

    public SpriteIRAM(Stage stage, int x, int y, int width, int height, Scrollbar scrollBar) {
        super(stage, "IRAM", x, y, width, height);
        this.scrollBar = scrollBar;
        this.addBoxes = new TextBox[64];
        this.datBoxes = new TextBox[64];
        this.data = new int[64];
        this.addNode("DAT", width - (int)((float)width * 0.33333334f), 0);
        this.addNode("ADD", -5, 50);
        int i = 0;
        while (i < 64) {
            this.addBoxes[i] = new TextBox(stage, 0, 0, 1, 1, Integer.toString(i * 2, 10), CPUTools.intToBinString(i * 2, 8), this.font, true, true);
            this.addBoxes[i].setBGColors(addColors);
            this.datBoxes[i] = new TextBox(stage, 0, 0, 1, 1, "", "", this.font, true, false);
            this.setValue(this.indexToAddress(i), "NOP");
            ++i;
        }
        this.updateScroll();
    }

    public String getStringValue(int address) {
        String value;
        int index = this.addressToIndex(address);
        if (this.stage.getMode() == 1) {
            value = CPUTools.int16ToInstruction(this.data[index]);
        } else {
            int top8 = CPUTools.top8Bits(this.data[index]);
            int bottom8 = CPUTools.bottom8Bits(this.data[index]);
            value = CPUTools.intToBinString(top8, 8) + " " + CPUTools.intToBinString(bottom8, 8);
        }
        return value;
    }

    public String checkValue(int address, String value) {
        if (this.stage.getMode() == 1) {
            CPUTools.instructionToInt16(value);
        } else {
            int iValue;
            String stripValue = this.stripWhite(value);
            try {
                iValue = Integer.valueOf(stripValue, 2);
            }
            catch (NumberFormatException numberFormatException) {
                return "not a legal binary number";
            }
            CPUTools.int16ToInstruction(iValue);
        }
        return CPUTools.error();
    }

    public String checkValue(int address, int value) {
        String error = CPUTools.int16ToInstruction(value);
        if (error != null) {
            return null;
        }
        return CPUTools.error();
    }

    public void setValue(int address, String value) {
        int iValue;
        if (this.stage.getMode() == 1) {
            this.setValue(address, CPUTools.instructionToInt16(value));
            return;
        }
        value = this.stripWhite(value);
        try {
            iValue = Integer.valueOf(value, 2);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        this.setValue(address, iValue);
    }

    public void setValue(int address, int value) {
        int index = this.addressToIndex(address);
        this.data[index] = value;
        String symString = CPUTools.int16ToInstruction(value);
        String binString = this.int16ToBin(this.data[index]);
        this.datBoxes[index].setText(symString, binString);
        this.markDirty();
    }

    public int firstAddress() {
        return 0;
    }

    public int lastAddress() {
        return 126;
    }

    public int nextAddress(int address) {
        if (address < this.lastAddress()) {
            return address + 2;
        }
        return this.firstAddress();
    }

    public int prevAddress(int address) {
        if (address > this.firstAddress()) {
            return address - 2;
        }
        return this.lastAddress();
    }

    public void flashAddress(int address) {
        this.showAddress(address);
        super.flashAddress(address);
    }

    public void flashData(int address) {
        this.showAddress(address);
        super.flashData(address);
    }

    public void updateScroll() {
        int top = this.y;
        int left = this.x;
        int mid = this.x + (int)((float)this.width * 0.33333334f);
        int right = this.x + this.width;
        int i = 0;
        while (i < 64) {
            if (i >= this.scroll && i < this.scroll + 8) {
                int bottom = this.y + (i + 1 - this.scroll) * this.height / 8;
                this.addBoxes[i].reshape(left, top, mid - left, bottom - top);
                this.datBoxes[i].reshape(mid - 1, top, right - mid + 1, bottom - top);
                top = bottom - 1;
            } else {
                this.addBoxes[i].reshape(-10, -10, 5, 5);
                this.datBoxes[i].reshape(-10, -10, 5, 5);
            }
            ++i;
        }
        this.toScroll();
        this.markDirty();
    }

    public boolean showAddress(int address) {
        int index = address / 2;
        if (index < this.scroll) {
            this.scroll = index;
            this.updateScroll();
            return true;
        }
        if (index >= this.scroll + 8) {
            this.scroll = index - 8 + 1;
            this.updateScroll();
            return true;
        }
        return false;
    }

    public void fromScroll() {
        int newScroll;
        if (this.scrollBar != null && (newScroll = this.scrollBar.getValue()) != this.scroll) {
            this.scroll = newScroll;
            this.updateScroll();
        }
    }

    public void toScroll() {
        if (this.scrollBar != null) {
            this.scrollBar.setValues(this.scroll, 8, 0, 56);
        }
    }

    public boolean drawAll(Graphics g) {
        this.markClean();
        int i = this.scroll;
        while (i < this.scroll + 8) {
            this.dirty |= this.addBoxes[i].drawAll(g);
            this.dirty |= this.datBoxes[i].drawAll(g);
            ++i;
        }
        if (this.dirtyPartner != null) {
            this.dirtyPartner.markDirty();
        }
        return this.dirty;
    }

    protected int addressToIndex(int address) {
        return address / 2;
    }

    protected int indexToAddress(int index) {
        return index * 2;
    }

    private String int16ToBin(int value) {
        int top8 = CPUTools.top8Bits(value);
        int bottom8 = CPUTools.bottom8Bits(value);
        return CPUTools.intToBinString(top8, 8) + "  " + CPUTools.intToBinString(bottom8, 8);
    }

    private String stripWhite(String value) {
        int pos = value.indexOf(32);
        while (pos != -1) {
            value = pos == 0 ? value.substring(1) : (pos == value.length() - 1 ? value.substring(0, pos) : value.substring(0, pos) + value.substring(pos + 1));
            pos = value.indexOf(32);
        }
        return value;
    }
}

