/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Graphics;
import screen.SpriteRAM;
import screen.Stage;
import screen.TextBox;
import util.CPUTools;

public class SpriteDRAM
extends SpriteRAM {
    static Color[] addColors = new Color[]{new Color(0, 255, 0), new Color(0, 255, 0), new Color(0, 255, 0), new Color(0, 255, 0), new Color(0, 255, 0), new Color(204, 204, 153), new Color(204, 204, 153), new Color(204, 204, 153), new Color(204, 204, 153), new Color(255, 204, 204)};

    public SpriteDRAM(Stage stage, int x, int y, int width, int height) {
        super(stage, "DRAM", x, y, width, height);
        this.addBoxes = new TextBox[8];
        this.datBoxes = new TextBox[8];
        this.data = new int[8];
        int top = y;
        int i = 0;
        while (i < 8) {
            int bottom = y + (i + 1) * height / 8;
            this.addBoxes[i] = new TextBox(stage, x, top, (int)((float)width * 0.33333334f), bottom - top, CPUTools.VARIABLES[i], Integer.toString(i + 128, 2), this.font, true, true);
            this.addBoxes[i].setBGColors(addColors);
            this.datBoxes[i] = new TextBox(stage, x + (int)((float)width * 0.33333334f) - 1, top, width - (int)((float)width * 0.33333334f) + 1, bottom - top, "0", "00000000", this.font, true, false);
            this.setValue(this.indexToAddress(i), 0);
            top = bottom - 1;
            ++i;
        }
    }

    public String checkValue(int address, String value) {
        int base = this.stage.getMode() == 1 ? 10 : 2;
        try {
            int result = CPUTools.stringToSEx8(value, base);
            return this.checkValue(address, result);
        }
        catch (NumberFormatException numberFormatException) {
            return "not a legal " + (base == 10 ? "decimal" : "binary") + " number";
        }
    }

    public String checkValue(int address, int value) {
        int base;
        int n = base = this.stage.getMode() == 1 ? 10 : 2;
        if (value < -128 || value > 127) {
            String error = "out of range: must be from " + (base == 10 ? "-128" : "10000000") + " to " + (base == 10 ? "127" : "01111111");
            return error;
        }
        return null;
    }

    public void setValue(int address, int value) {
        int i;
        int index = this.addressToIndex(address);
        this.data[index] = i = CPUTools.intToSEx8(value);
        String symText = CPUTools.sEx8ToDecString(i);
        String binText = CPUTools.sEx8ToBinString(i);
        this.datBoxes[index].setText(symText, binText);
        this.markDirty();
    }

    public void setValue(int address, String value) {
        try {
            int base = this.stage.getMode() == 1 ? 10 : 2;
            int result = CPUTools.stringToSEx8(value, base);
            this.setValue(address, result);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public String getStringValue(int address) {
        int index = this.addressToIndex(address);
        if (this.stage.getMode() == 1) {
            return CPUTools.sEx8ToDecString(this.data[index]);
        }
        return CPUTools.sEx8ToBinString(this.data[index]);
    }

    public int firstAddress() {
        return 128;
    }

    public int lastAddress() {
        return 128 + this.data.length - 1;
    }

    public int nextAddress(int address) {
        if (address < this.lastAddress()) {
            return address + 1;
        }
        return this.firstAddress();
    }

    public int prevAddress(int address) {
        if (address == this.firstAddress()) {
            return this.lastAddress();
        }
        return address - 1;
    }

    public boolean showAddress(int address) {
        return false;
    }

    public boolean drawAll(Graphics g) {
        this.markClean();
        int i = 0;
        while (i < 8) {
            this.dirty |= this.addBoxes[i].drawAll(g);
            this.dirty |= this.datBoxes[i].drawAll(g);
            ++i;
        }
        if (this.dirtyPartner != null) {
            this.dirtyPartner.markDirty();
        }
        return this.dirty;
    }

    protected int addressToIndex(int address) {
        return address - 128;
    }

    protected int indexToAddress(int index) {
        return index + 128;
    }
}

