/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import screen.SpriteRAM;
import screen.Stage;
import screen.TextBox;
import util.CPUTools;

public class SpriteBox
extends SpriteRAM {
    TextBox box;
    Font font = new Font("Helvetica", 0, 12);
    int value;
    String symText;
    String binText;
    public boolean isPC = false;

    public SpriteBox(Stage stage, String name, int x, int y, int width, int height, String symText, String binText) {
        super(stage, name, x, y, width, height);
        this.box = new TextBox(stage, x, y, width, height, symText, binText, this.font, true, true);
    }

    public SpriteBox(Stage stage, String name, int x, int y, int width, int height, int value) {
        super(stage, name, x, y, width, height);
        this.symText = Integer.toString(value, 10);
        this.binText = CPUTools.intToBinString(value, 8);
        this.box = new TextBox(stage, x, y, width, height, this.symText, this.binText, this.font, true, true);
    }

    public void setText(String symText, String binText) {
        this.symText = symText;
        this.binText = binText;
        this.box.setText(symText, binText);
        this.markDirty();
    }

    public String checkValue(int address, String value) {
        int base = this.stage.getMode() == 1 ? 10 : 2;
        try {
            int result = CPUTools.stringToSEx8(value, base);
            return this.checkValue(address, result);
        }
        catch (NumberFormatException numberFormatException) {
            return "not a legal " + (base == 10 ? "decimal" : "binary") + " number";
        }
    }

    public String checkValue(int address, int value) {
        int base = this.stage.getMode() == 1 ? 10 : 2;
        if (value < (this.isPC ? 0 : -128) || value > 127) {
            return "out of range: must be from " + (base == 10 ? (this.isPC ? "0" : "-128") : (this.isPC ? "00000000" : "10000000")) + " to " + (base == 10 ? (this.isPC ? "126" : "127") : (this.isPC ? "01111110" : "01111111"));
        }
        if (this.isPC && value % 2 == 1) {
            return "value must be even";
        }
        return null;
    }

    public void setValue(int value) {
        this.value = CPUTools.intToSEx8(value);
        String symText = CPUTools.sEx8ToDecString(this.value);
        String binText = CPUTools.sEx8ToBinString(this.value);
        this.setText(symText, binText);
        this.markDirty();
    }

    public void setValue(int address, int value) {
        this.setValue(value);
    }

    public void setValue(int address, String value) {
        try {
            int base = this.stage.getMode() == 1 ? 10 : 2;
            int result = CPUTools.stringToSEx8(value, base);
            this.setValue(address, result);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public int getValue() {
        return this.value;
    }

    public int getValue(int address) {
        return this.getValue();
    }

    public String getStringValue(int address) {
        String result = this.stage.getMode() == 1 ? CPUTools.sEx8ToDecString(this.value) : CPUTools.sEx8ToBinString(this.value);
        return result;
    }

    public int firstAddress() {
        return 0;
    }

    public int lastAddress() {
        return 0;
    }

    public int nextAddress(int address) {
        return 0;
    }

    public int prevAddress(int address) {
        return 0;
    }

    public boolean showAddress(int addres) {
        return false;
    }

    public void flashAddress(int address) {
    }

    public void flashData(int address) {
    }

    public int clickToAddress(int x, int y) {
        return 0;
    }

    public Rectangle addressToRect(int address) {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void flashText() {
        this.box.flashText();
        this.markDirty();
    }

    public void flashBG() {
        this.box.flashBG();
        this.markDirty();
    }

    public boolean drawAll(Graphics g) {
        this.markClean();
        this.dirty |= this.box.drawAll(g);
        if (this.dirtyPartner != null) {
            this.dirtyPartner.markDirty();
        }
        return this.dirty;
    }

    protected int addressToIndex(int address) {
        return 0;
    }

    protected int indexToAddress(int index) {
        return 0;
    }
}

