/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import screen.Letter;
import screen.SpriteComponent;
import screen.Stage;
import screen.TextBox;
import util.CPUTools;

public class SpriteALU
extends SpriteComponent {
    TextBox leftArgBox;
    TextBox rightArgBox;
    Letter operator;
    Font argFont = new Font("Helvetica", 0, 12);
    static final int ARG_HEIGHT = 16;
    static final int ARG_VSPACE = 5;
    static final int OP_WIDTH = 15;
    static final int OP_HEIGHT = 15;
    static final float SLOPE = 3.0f;
    static final int V_WIDTH = 16;
    static final int INPUT_DIST = 35;
    Polygon border;
    Color bgColor = new Color(224, 224, 224);

    public SpriteALU(Stage stage, int x, int y, int width, int height) {
        super(stage, "ALU", x, y, width, height);
        this.addNode("DAT", 35, 0);
        this.addNode("MUX", width - 35, 0);
        this.addNode("DEC", (int)((float)(height / 2) / 3.0f), height / 2);
        this.addNode("ACC", width / 2, height);
        int veeHeight = 24;
        this.border = new Polygon();
        this.border.addPoint(x, y);
        this.border.addPoint(x + (width - 16) / 2, y);
        this.border.addPoint(x + width / 2, y + veeHeight);
        this.border.addPoint(x + (width + 16) / 2, y);
        this.border.addPoint(x + width, y);
        this.border.addPoint(x + width - (int)((float)height / 3.0f), y + height);
        this.border.addPoint(x + (int)((float)height / 3.0f), y + height);
        this.border.addPoint(x, y);
        int argWidth = (width - 16) / 2 - 5;
        int argHSpace = 7;
        this.leftArgBox = new TextBox(stage, x + argHSpace, y + 5, argWidth, 16, "", "", this.argFont, false, true);
        this.rightArgBox = new TextBox(stage, x + width - (argWidth + argHSpace), y + 5, argWidth, 16, "", "", this.argFont, false, true);
        this.operator = new Letter(x + (width - 15) / 2, y + (veeHeight + height - 15) / 2, 15, 15);
    }

    public void setLeftArg(int value) {
        int extendedValue = ((value &= 0xFF) & 0x80) != 0 ? value | 0xFFFFFF00 : value;
        this.leftArgBox.setText(Integer.toString(extendedValue, 10), CPUTools.intToBinString(value, 8));
        this.leftArgBox.flashBG();
        this.markDirty();
    }

    public void setRightArg(int value) {
        int extendedValue = ((value &= 0xFF) & 0x80) != 0 ? value | 0xFFFFFF00 : value;
        this.rightArgBox.setText(Integer.toString(extendedValue, 10), CPUTools.intToBinString(value, 8));
        this.rightArgBox.flashBG();
        this.markDirty();
    }

    public void setOperation(char op) {
        this.operator.set(op);
        this.operator.flashBG();
        this.markDirty();
    }

    public void clear() {
        this.leftArgBox.setText("", "");
        this.rightArgBox.setText("", "");
        this.operator.set(' ');
        this.markDirty();
    }

    public boolean drawAll(Graphics g) {
        this.markClean();
        g.setColor(this.bgColor);
        g.fillPolygon(this.border);
        this.dirty |= this.leftArgBox.drawAll(g);
        this.dirty |= this.rightArgBox.drawAll(g);
        this.dirty |= this.operator.drawAll(g);
        g.setColor(Color.black);
        g.drawPolygon(this.border);
        if (this.dirtyPartner != null) {
            this.dirtyPartner.markDirty();
        }
        return this.dirty;
    }

    public boolean drawNew(Graphics g) {
        this.markClean();
        this.dirty |= this.leftArgBox.drawNew(g);
        this.dirty |= this.rightArgBox.drawNew(g);
        this.dirty |= this.operator.drawNew(g);
        g.setColor(Color.black);
        g.drawPolygon(this.border);
        if (this.dirtyPartner != null) {
            this.dirtyPartner.markDirty();
        }
        return this.dirty;
    }
}

