/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import screen.AbortedException;
import screen.SpriteWire;

public class Node {
    boolean propagating = false;
    Vector wires = new Vector(5);
    String name;
    int x;
    int y;

    public Node(String name, int x, int y) {
        this.name = name;
        this.x = x;
        this.y = y;
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public String name() {
        return this.name;
    }

    public void addWire(SpriteWire wire) {
        this.wires.addElement(wire);
    }

    public boolean animateFrom(Node node) throws AbortedException {
        try {
            if (this.propagating) {
                return false;
            }
            if (node == this) {
                return true;
            }
            this.propagating = true;
            Enumeration e = this.wires.elements();
            while (e.hasMoreElements()) {
                SpriteWire wire = (SpriteWire)e.nextElement();
                if (!wire.animateFrom(node)) continue;
                this.propagating = false;
                return true;
            }
            this.propagating = false;
            return false;
        }
        catch (AbortedException e) {
            this.propagating = false;
            throw e;
        }
    }

    public synchronized void dispose() {
        if (this.wires != null) {
            Vector tempWires = (Vector)this.wires.clone();
            int i = 0;
            while (i < tempWires.size()) {
                ((SpriteWire)tempWires.elementAt(i)).dispose();
                ++i;
            }
            this.wires.removeAllElements();
            this.wires = null;
        }
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + ", wires.length=" + this.wires.size() + ", x=" + this.x + ", y=" + this.y + "]";
    }
}

