/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import util.ColorTools;

public class Letter {
    int x;
    int y;
    int width;
    int height;
    char c = (char)32;
    long textTime;
    long bgTime;
    static final int COLOR_COUNT = 10;
    static Color[] textColors = ColorTools.interpArrayHSB(Color.red, Color.black, 10);
    static Color[] bgColors = ColorTools.interpArrayHSB(Color.green, new Color(224, 224, 224), 10);
    boolean dirty = true;

    public Letter(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void reshape(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.dirty = true;
    }

    public Rectangle getRect() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public boolean inside(int x, int y) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    public void set(char c) {
        this.c = c;
        this.dirty = true;
    }

    public void flashText() {
        this.textTime = System.currentTimeMillis();
        this.dirty = true;
    }

    public void flashBG() {
        this.bgTime = System.currentTimeMillis();
        this.dirty = true;
    }

    public boolean drawAll(Graphics g) {
        this.dirty = false;
        this.dirty |= ColorTools.setColor(g, bgColors, this.bgTime);
        g.fillRect(this.x, this.y, this.width + 1, this.height + 1);
        this.dirty |= ColorTools.setColor(g, textColors, this.textTime);
        switch (this.c) {
            case '+': {
                this.drawLine(g, new Point(this.x, this.y + this.height / 2), new Point(this.x + this.width, this.y + this.height / 2), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x, this.y + this.height / 2 + 1), new Point(this.x + this.width, this.y + this.height / 2 + 1), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 2, this.y), new Point(this.x + this.width / 2, this.y + this.height), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 2 + 1, this.y), new Point(this.x + this.width / 2 + 1, this.y + this.height), 3, Color.black, Color.black);
                break;
            }
            case '-': {
                this.drawLine(g, new Point(this.x, this.y + this.height / 2), new Point(this.x + this.width, this.y + this.height / 2), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x, this.y + this.height / 2 + 1), new Point(this.x + this.width, this.y + this.height / 2 + 1), 3, Color.black, Color.black);
                break;
            }
            case '*': {
                this.drawLine(g, new Point(this.x, this.y + this.height / 2), new Point(this.x + this.width - 1, this.y + this.height / 2), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x, this.y + this.height / 2 - 1), new Point(this.x + this.width - 1, this.y + this.height / 2 - 1), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 4, this.y + this.height / 6), new Point(this.x + 3 * this.width / 4 + 1, this.y + 5 * this.height / 6 - 1), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 4 - 1, this.y + this.height / 6), new Point(this.x + 3 * this.width / 4, this.y + 5 * this.height / 6 - 1), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + 3 * this.width / 4, this.y + this.height / 6), new Point(this.x + this.width / 4 - 1, this.y + 5 * this.height / 6 - 1), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + 3 * this.width / 4 + 1, this.y + this.height / 6), new Point(this.x + this.width / 4, this.y + 5 * this.height / 6 - 1), 3, Color.black, Color.black);
                break;
            }
            case '/': {
                this.drawLine(g, new Point(this.x + 3 * this.width / 4, this.y), new Point(this.x + this.width / 4, this.y + this.height), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + 3 * this.width / 4 + 1, this.y), new Point(this.x + this.width / 4 + 1, this.y + this.height), 3, Color.black, Color.black);
                break;
            }
            case '=': {
                this.drawLine(g, new Point(this.x, this.y + 2 * this.height / 6), new Point(this.x + this.width, this.y + 2 * this.height / 6), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x, this.y + 2 * this.height / 6 + 1), new Point(this.x + this.width, this.y + 2 * this.height / 6 + 1), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x, this.y + 4 * this.height / 6), new Point(this.x + this.width, this.y + 4 * this.height / 6), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x, this.y + 4 * this.height / 6 + 1), new Point(this.x + this.width, this.y + 4 * this.height / 6 + 1), 3, Color.black, Color.black);
                break;
            }
            case ':': {
                this.drawLine(g, new Point(this.x + this.width / 2, this.y + this.height / 3), new Point(this.x + this.width / 2, this.y + (this.height / 3 + 3)), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 2 + 1, this.y + this.height / 3), new Point(this.x + this.width / 2 + 1, this.y + (this.height / 3 + 3)), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 2, this.y + 2 * this.height / 3), new Point(this.x + this.width / 2, this.y + 2 * this.height / 3 + 3), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 2 + 1, this.y + 2 * this.height / 3), new Point(this.x + this.width / 2 + 1, this.y + 2 * this.height / 3 + 3), 3, Color.black, Color.black);
                break;
            }
            case '^': {
                this.drawLine(g, new Point(this.x + this.width / 2, this.y), new Point(this.x, this.y + this.height), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 2, this.y), new Point(this.x + this.width, this.y + this.height), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 2 + 1, this.y), new Point(this.x + 1, this.y + this.height), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 2 + 1, this.y), new Point(this.x + this.width, this.y + this.height - 1), 3, Color.black, Color.black);
                break;
            }
            case '!': {
                this.drawLine(g, new Point(this.x + this.width / 2, this.y), new Point(this.x + this.width / 2, this.y + 7 * this.height / 10), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 2 + 1, this.y), new Point(this.x + this.width / 2 + 1, this.y + 7 * this.height / 10), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 2, this.y + 8 * this.height / 10), new Point(this.x + this.width / 2, this.y + this.height), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width / 2 + 1, this.y + 8 * this.height / 10), new Point(this.x + this.width / 2 + 1, this.y + this.height), 3, Color.black, Color.black);
                break;
            }
            case '<': {
                this.drawLine(g, new Point(this.x + this.width, this.y), new Point(this.x, this.y + this.height / 2), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x + this.width - 1, this.y), new Point(this.x, this.y + this.height / 2 - 1), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x, this.y + this.height / 2), new Point(this.x + this.width, this.y + this.height), 3, Color.black, Color.black);
                this.drawLine(g, new Point(this.x, this.y + this.height / 2 - 1), new Point(this.x + this.width, this.y + this.height - 1), 3, Color.black, Color.black);
                break;
            }
        }
        return this.dirty;
    }

    public boolean drawNew(Graphics g) {
        if (this.dirty) {
            return this.drawAll(g);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }

    private void drawLine(Graphics g, Point start, Point end, int width, Color fill, Color border) {
        g.setColor(fill);
        g.drawLine(start.x, start.y, end.x, end.y);
    }
}

