/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import screen.AbortedException;
import screen.Node;
import screen.SpriteALU;
import screen.SpriteBox;
import screen.SpriteDRAM;
import screen.SpriteEditBox;
import screen.SpriteIR;
import screen.SpriteIRAM;
import screen.SpriteLabel;
import screen.SpriteMUX;
import screen.SpriteRAM;
import screen.SpriteRect;
import screen.SpriteWire;
import screen.Stage;
import util.ButtonDialog;
import util.CPUTools;
import util.Global;

public class CPU
extends Panel
implements Runnable {
    Stage stage;
    Scrollbar scrollBar;
    Applet applet;
    Global mode = new Global("mode", 1);
    public static final int SYMBOLIC = 1;
    public static final int BINARY = 2;
    SpriteIR spriteIR;
    SpriteBox spriteDEC;
    SpriteMUX spriteMUX;
    SpriteALU spriteALU;
    SpriteBox spriteACC;
    SpriteBox spriteINC;
    SpriteBox spritePC;
    public SpriteIRAM spriteIRAM;
    public SpriteDRAM spriteDRAM;
    SpriteRect spriteABUS;
    Color bgColor = Color.lightGray;
    static final int BORDER = 27;
    static final int FLASH_TIME = 500;
    int barWidth;
    static final int VARIABLE_BASE = 128;
    boolean running = true;
    Thread thread;
    int steps;
    boolean reset = false;
    boolean halted = false;
    boolean gotFocus = false;
    boolean stepping = false;
    SpriteRAM editRAM;
    SpriteEditBox editBox;
    int editAddress;

    public CPU(Applet applet) {
        this.applet = applet;
        this.setLayout(null);
        this.setBackground(this.bgColor);
        this.reshape(4, 4, 592, 295);
        this.scrollBar = new Scrollbar(1);
        applet.add(this.scrollBar);
        this.barWidth = this.scrollBar.preferredSize().width;
        applet.remove(this.scrollBar);
        this.scrollBar = new Scrollbar(1);
        this.add(this.scrollBar);
        this.scrollBar.reshape(this.size().width - 27, 30, this.barWidth, 129);
        this.buildStage();
        this.internalReset();
        this.thread = new Thread((Runnable)this, "EventHandler");
        this.thread.start();
    }

    public synchronized void clear() {
        this.reset();
        SpriteRAM theRAM = this.spriteIRAM;
        int theValue = CPUTools.instructionToInt16("NOP");
        while (true) {
            int i = ((SpriteRAM)theRAM).firstAddress();
            while (true) {
                ((SpriteRAM)theRAM).setValue(i, theValue);
                if (i == ((SpriteRAM)theRAM).lastAddress()) break;
                i = ((SpriteRAM)theRAM).nextAddress(i);
            }
            if (theRAM == this.spriteDRAM) break;
            theRAM = this.spriteDRAM;
            theValue = 0;
        }
    }

    public synchronized void reset() {
        if (this.editWrite()) {
            this.steps = 0;
            this.reset = true;
            while (this.stepping) {
                this.stage.aborting(true);
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.stage.aborting(false);
            this.notifyAll();
        }
    }

    public synchronized void stop() {
        if (this.editWrite()) {
            this.steps = 0;
            while (this.stepping) {
                this.stage.aborting(true);
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.stage.aborting(false);
            this.notifyAll();
        }
    }

    public synchronized void step() {
        this.halted = false;
        if (this.editWrite()) {
            ++this.steps;
            this.notifyAll();
        }
    }

    public synchronized void play() {
        this.halted = false;
        if (this.editWrite()) {
            this.steps = 1000;
            this.notifyAll();
        }
    }

    public synchronized void changeMode(int mode) {
        this.editWrite();
        this.mode.setInt(mode);
        if (this.editBox != null) {
            this.editBox.setValue(this.editRAM.getStringValue(this.editAddress));
        }
        this.repaint();
    }

    public void run() {
        while (this.running) {
            boolean step;
            CPU cPU = this;
            synchronized (cPU) {
                if (!this.reset && this.steps == 0) {
                    this.stepping = false;
                    this.notifyAll();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    this.stepping = true;
                }
                if (this.steps > 0) {
                    step = true;
                    --this.steps;
                } else {
                    step = false;
                }
            }
            if (this.reset) {
                this.steps = 0;
                this.internalReset();
                this.reset = false;
                continue;
            }
            if (!this.internalDone()) {
                if (!step) continue;
                step = false;
                this.internalStep();
                continue;
            }
            this.steps = 0;
        }
    }

    public boolean handleEvent(Event evt) {
        if (evt.id == 605 || evt.id == 602 || evt.id == 601 || evt.id == 604 || evt.id == 603) {
            this.spriteIRAM.fromScroll();
            if (this.editRAM == this.spriteIRAM) {
                Rectangle rect = this.editRAM.addressToRect(this.editAddress);
                rect.grow(-1, -1);
                this.editBox.reshape(rect);
            }
            return true;
        }
        return super.handleEvent(evt);
    }

    public boolean gotFocus(Event evt, Object what) {
        this.gotFocus = true;
        return true;
    }

    public boolean lostFocus(Event evt, Object what) {
        this.gotFocus = false;
        return true;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        if (this.stepping) {
            return false;
        }
        if (!this.gotFocus) {
            this.requestFocus();
        }
        if (this.editWrite()) {
            if (this.spriteDRAM.inside(x, y)) {
                this.editRAM = this.spriteDRAM;
            } else if (this.spriteIRAM.inside(x, y)) {
                this.editRAM = this.spriteIRAM;
            } else if (this.spritePC.inside(x, y)) {
                this.editRAM = this.spritePC;
            } else if (this.spriteACC.inside(x, y)) {
                this.editRAM = this.spriteACC;
            } else {
                return true;
            }
            this.editAddress = this.editRAM.clickToAddress(x, y);
            if (this.editAddress == -1) {
                this.editRAM = null;
                return true;
            }
            Rectangle rect = this.editRAM.addressToRect(this.editAddress);
            rect.grow(-1, -1);
            String text = this.editRAM.getStringValue(this.editAddress);
            this.editBox = new SpriteEditBox(this.stage, rect.x, rect.y, rect.width, rect.height, text, this.editRAM != this.spriteIRAM && this.editRAM != this.spriteDRAM);
            this.editBox.addStage(3);
        }
        return true;
    }

    public boolean keyDown(Event evt, int key) {
        System.out.println("CPU.keyDown: any " + key);
        if (this.editRAM == null) {
            return false;
        }
        if (key == 9 || key == 13 || key == 10 || key == 1004 || key == 1005) {
            System.out.println("CPU.keyDown: return " + key);
            int oldAddress = this.editAddress;
            SpriteRAM oldEditRAM = this.editRAM;
            if (!this.editWrite()) {
                return true;
            }
            this.editRAM = oldEditRAM;
            this.editAddress = evt.shiftDown() && key == 1004 ? this.editRAM.nextAddress(oldAddress) : (evt.shiftDown() && key != 1004 || key == 1004 ? this.editRAM.prevAddress(oldAddress) : this.editRAM.nextAddress(oldAddress));
            this.editRAM.showAddress(this.editAddress);
            Rectangle rect = this.editRAM.addressToRect(this.editAddress);
            rect.grow(-1, -1);
            String text = this.editRAM.getStringValue(this.editAddress);
            this.editBox = new SpriteEditBox(this.stage, rect.x, rect.y, rect.width, rect.height, text, this.editRAM != this.spriteIRAM && this.editRAM != this.spriteDRAM);
            this.editBox.addStage(3);
            return true;
        }
        if (this.editRAM.showAddress(this.editAddress)) {
            Rectangle rect = this.editRAM.addressToRect(this.editAddress);
            rect.grow(-1, -1);
            this.editBox.reshape(rect);
        }
        this.editBox.addKey((char)key);
        return true;
    }

    public boolean editWrite() {
        String error;
        if (this.editRAM == null) {
            return true;
        }
        String value = this.editBox.getValue();
        if (value == null) {
            System.err.println("Internal error, CPU.editWrite: null value");
        }
        if ((error = this.editRAM.checkValue(this.editAddress, value)) != null) {
            String title = this.editRAM == this.spriteIRAM ? "Error writing instruction" : (this.editRAM == this.spriteDRAM ? "Error writing RAM location" : (this.editRAM == this.spritePC ? "Error writing Program Counter" : (this.editRAM == this.spriteACC ? "Error writing Accumulator" : "Error writing value")));
            String message = "Error setting the value to \"" + value + "\":\n" + error + ".";
            ButtonDialog.showOKDialog(this, title, message);
            this.editBox.setValue(this.editRAM.getStringValue(this.editAddress));
            return false;
        }
        this.stage.removeSprite(this.editBox);
        this.editBox.dispose();
        this.editRAM.setValue(this.editAddress, value);
        this.editRAM = null;
        this.editBox = null;
        return true;
    }

    private Frame getFrame() {
        Container parent = this.getParent();
        while (parent != null && !(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        return (Frame)parent;
    }

    public void repaint() {
        this.stage.repaint();
        super.repaint();
    }

    public void updateStage() {
        this.stage.update(null);
    }

    public void dispose() {
        if (this.thread != null) {
            this.thread.stop();
            CPU cPU = this;
            synchronized (cPU) {
                this.notifyAll();
            }
            this.thread = null;
        }
        if (this.stage != null) {
            this.stage.removeAllSprites();
        }
        this.stage = null;
    }

    private void buildStage() {
        this.stage = new Stage(this.bgColor, new Dimension(565, 295), this.mode);
        this.stage.reshape(0, 0, 565, 295);
        this.add(this.stage);
        this.spriteIR = new SpriteIR(this.stage, 35, 30, 140, 20);
        this.spriteIR.addStage(2);
        this.makeLabel("IR", 35, 30, 140, 20, 1);
        this.spriteDEC = new SpriteBox(this.stage, "DEC", 35, 100, 70, 20, "Decoder", "Decoder");
        this.spriteDEC.addNode("IR", 35, 0);
        this.spriteDEC.addNode("ALU", 35, 20);
        this.spriteDEC.addNode("MUX", 70, 10);
        this.spriteDEC.addStage(2);
        this.spriteMUX = new SpriteMUX(this.stage, 185, 100, 60, 20);
        this.spriteMUX.addStage(2);
        this.spriteALU = new SpriteALU(this.stage, 90, 170, 160, 50);
        this.spriteALU.addStage(2);
        this.makeLabel("ALU", 90, 170, 160, 50, 2);
        this.spriteACC = new SpriteBox(this.stage, "ACC", 135, 250, 70, 20, 0);
        this.spriteACC.addNode("ALU", 35, 0);
        this.spriteACC.addNode("DAT", 35, 20);
        this.spriteACC.addStage(2);
        this.makeLabel("ACC", 135, 250, 70, 20, 1);
        this.spriteINC = new SpriteBox(this.stage, "INC", 300, 100, 30, 20, "+2", "+10");
        this.spriteINC.addNode("ADD", 15, 0);
        this.spriteINC.addNode("PC", 15, 20);
        this.spriteINC.addStage(2);
        this.spritePC = new SpriteBox(this.stage, "PC", 280, 145, 70, 20, 0);
        this.spritePC.addNode("INC", 35, 0);
        this.spritePC.addNode("ADD", 35, 20);
        this.spritePC.isPC = true;
        this.spritePC.addStage(2);
        this.makeLabel("PC", 280, 145, 70, 20, 1);
        this.spriteIRAM = new SpriteIRAM(this.stage, 365, 30, 200, 129, this.scrollBar);
        this.spriteIRAM.addStage(2);
        this.spriteDRAM = new SpriteDRAM(this.stage, 365, 160, 200, 129);
        this.spriteDRAM.addStage(2);
        this.spriteABUS = new SpriteRect(this.stage, 360, 30, 5, 259);
        this.spriteABUS.addStage(2);
        this.makeLabel("RAM", 360, 30, 5, 258, 1);
        this.makeNode("ADD4", 265, 180);
        this.makeNode("DAT3", 15, 140);
        this.makeNode("DAT1", "ACC:DAT", 285);
        this.makeNode("DAT6", "IR:DAT", 10);
        this.makeNode("DAT2", "DAT3", "DAT1");
        this.makeNode("DAT4", "ALU:DAT", "DAT3");
        this.makeNode("DAT5", "DAT3", "DAT6");
        this.makeNode("DAT7", "MUX:DAT", "DAT6");
        this.makeNode("DAT8", "IRAM:DAT", "DAT6");
        this.makeNode("ADD1", "IR:ADD", "IRAM:ADD");
        this.makeNode("ADD2", "MUX:ADD", "IRAM:ADD");
        this.makeNode("ADD3", "ADD4", "IRAM:ADD");
        this.makeNode("ADD5", "PC:ADD", "ADD4");
        this.makeNode("ADD6", "INC:ADD", "IRAM:ADD");
        this.makeNode("DEC1", "DEC:ALU", "ALU:DEC");
        this.makeWire("ACC:DAT", "DAT1");
        this.makeWire("DAT1", "DAT2");
        this.makeWire("DAT2", "DAT3");
        SpriteWire tempA = this.makeWire("DAT3", "DAT4");
        this.makeWire("DAT4", "ALU:DAT");
        this.makeWire("DAT3", "DAT5");
        this.makeWire("DAT5", "DAT6");
        this.makeWire("DAT6", "IR:DAT");
        this.makeWire("DAT6", "DAT7");
        SpriteWire tempC = this.makeWire("DAT7", "MUX:DAT");
        this.makeWire("DAT7", "DAT8");
        this.makeWire("DAT8", "IRAM:DAT");
        this.makeWire("IR:ADD", "ADD1");
        this.makeWire("ADD1", "ADD2");
        this.makeWire("ADD2", "MUX:ADD");
        SpriteRect temp2 = this.makeRect(this.bgColor, "DAT7", "ADD3");
        SpriteWire tempD = this.makeWire("ADD2", "ADD3");
        tempC.setDirtyPartner(temp2);
        temp2.setDirtyPartner(tempD);
        this.makeWire("ADD3", "ADD4");
        this.makeWire("ADD4", "ADD5");
        this.makeWire("ADD5", "PC:ADD");
        this.makeWire("ADD3", "ADD6");
        this.makeWire("ADD6", "INC:ADD");
        this.makeWire("ADD6", "IRAM:ADD");
        this.makeWire("IR:DEC", "DEC:IR");
        SpriteRect temp1 = this.makeRect(this.bgColor, "DEC1", "DAT3");
        SpriteWire tempB = this.makeWire("DEC:ALU", "DEC1");
        tempA.setDirtyPartner(temp1);
        temp1.setDirtyPartner(tempB);
        this.makeWire("DEC1", "ALU:DEC");
        this.makeWire("ALU:ACC", "ACC:ALU");
        this.makeWire("DEC:MUX", "MUX:DEC");
        this.makeWire("MUX:ALU", "ALU:MUX");
        this.makeWire("INC:PC", "PC:INC");
    }

    private void internalStep() {
        try {
            boolean direct;
            int opcode = CPUTools.top8Bits(this.getIRAM(this.getPC()));
            int operand = CPUTools.bottom8Bits(this.getIRAM(this.getPC()));
            boolean bl = direct = opcode < 16;
            if (!direct) {
                opcode -= 16;
            }
            boolean jumping = false;
            boolean divideByZero = false;
            boolean overflow = false;
            this.spriteIR.clear();
            this.spriteALU.clear();
            this.spriteMUX.clear();
            this.spritePC.flashBG();
            this.delay(500);
            this.flashWire("PC:ADD", "IRAM:ADD");
            this.spriteABUS.flash();
            this.delay(250);
            this.spriteIRAM.showAddress(this.getPC());
            this.spriteIRAM.flashAddress(this.getPC());
            this.delay(500);
            this.spriteIRAM.flashData(this.getPC());
            this.delay(500);
            this.flashWire("IRAM:DAT", "IR:DAT");
            this.spriteIR.setValue(this.getIRAM(this.getPC()));
            this.spriteIR.flashOperator();
            this.spriteIR.flashOperand();
            this.delay(500);
            this.spriteIR.flashOperator();
            if (opcode <= 4 || opcode == 8 || opcode == 10 || opcode == 11) {
                char operation = CPUTools.opcodeToOperation(opcode);
                int argument = 0;
                int result = 0;
                argument = direct ? this.getDRAM(operand) : CPUTools.intToSEx8(operand);
                switch (operation) {
                    case '+': {
                        result = this.getACC() + argument;
                        break;
                    }
                    case '-': {
                        result = this.getACC() - argument;
                        break;
                    }
                    case '*': {
                        result = this.getACC() * argument;
                        break;
                    }
                    case '/': {
                        if (argument == 0) {
                            divideByZero = true;
                            break;
                        }
                        result = this.getACC() / argument;
                        break;
                    }
                    case '=': {
                        result = argument;
                        break;
                    }
                    case '&': {
                        result = this.getACC() & argument;
                        break;
                    }
                    case ':': {
                        if (argument == 0) {
                            result = 1;
                            break;
                        }
                        result = 0;
                        break;
                    }
                    case '<': {
                        if (argument < 0) {
                            result = 1;
                            break;
                        }
                        result = 0;
                        break;
                    }
                }
                if (result != CPUTools.intToSEx8(result)) {
                    overflow = true;
                }
                result = CPUTools.intToSEx8(result);
                this.flashWire("IR:DEC", "DEC:IR");
                this.spriteDEC.flashBG();
                this.delay(500);
                this.flashWire("DEC:MUX", "MUX:DEC");
                this.spriteMUX.set(direct);
                this.spriteMUX.flashBG();
                this.delay(500);
                this.flashWire("DEC:ALU", "ALU:DEC");
                this.spriteALU.setOperation(operation);
                this.delay(500);
                if (operation != '=' && operation != ':' && operation != '<') {
                    this.spriteACC.flashBG();
                    this.delay(500);
                    this.flashWire("ACC:DAT", "ALU:DAT");
                    this.spriteALU.setLeftArg(this.getACC());
                    this.delay(500);
                }
                if (operation == ':' || operation == '<') {
                    this.spriteALU.setLeftArg(0);
                    this.delay(500);
                }
                this.spriteIR.flashOperand();
                this.delay(500);
                if (direct) {
                    this.flashWire("IR:ADD", "IRAM:ADD");
                    this.spriteABUS.flash();
                    this.delay(250);
                    this.spriteDRAM.flashAddress(operand);
                    this.delay(500);
                    this.spriteDRAM.flashData(operand);
                    this.delay(500);
                    this.flashWire("IRAM:DAT", "MUX:DAT");
                } else {
                    this.spriteIR.flashOperand();
                    this.flashWire("IR:ADD", "MUX:ADD");
                }
                this.spriteMUX.flashLine();
                this.flashWire("MUX:ALU", "ALU:MUX");
                this.spriteALU.setRightArg(argument);
                this.delay(500);
                this.spriteALU.setOperation(operation);
                this.delay(500);
                if (divideByZero) {
                    String title = "Divide By Zero";
                    String message = "Error: ALU tried to divide by zero";
                    ButtonDialog.showOKDialog(this, null, title, message);
                    this.halted = true;
                } else {
                    if (overflow) {
                        String title = "Arithmetic Overflow";
                        String message = "Error: ALU overflowed";
                        ButtonDialog.showOKDialog(this, null, title, message);
                        this.halted = true;
                    }
                    this.flashWire("ALU:ACC", "ACC:ALU");
                    this.setACC(result);
                    this.spriteACC.flashBG();
                    this.delay(500);
                }
            } else if (opcode == 5) {
                this.flashWire("IR:DEC", "DEC:IR");
                this.spriteDEC.flashBG();
                this.delay(500);
                this.flashWire("IR:ADD", "IRAM:ADD");
                this.spriteABUS.flash();
                this.delay(250);
                this.spriteDRAM.flashAddress(operand);
                this.delay(500);
                this.spriteACC.flashBG();
                this.delay(500);
                this.flashWire("ACC:DAT", "IRAM:DAT");
                this.setDRAM(operand, this.getACC());
                this.spriteDRAM.flashData(operand);
                this.delay(500);
            } else if (opcode == 9) {
                char noperation = CPUTools.opcodeToOperation(opcode);
                this.flashWire("IR:DEC", "DEC:IR");
                this.spriteDEC.flashBG();
                this.delay(500);
                this.flashWire("DEC:ALU", "ALU:DEC");
                this.spriteALU.setOperation(noperation);
                this.delay(500);
                this.spriteACC.flashBG();
                this.delay(500);
                this.flashWire("ACC:DAT", "ALU:DAT");
                this.spriteALU.setLeftArg(this.getACC());
                this.delay(500);
                this.spriteALU.setOperation(noperation);
                this.delay(500);
                this.flashWire("ALU:ACC", "ACC:ALU");
                if (this.getACC() == 0) {
                    this.setACC(1);
                } else {
                    this.setACC(0);
                }
                this.delay(500);
            } else if (opcode == 12) {
                jumping = true;
                this.flashWire("IR:DEC", "DEC:IR");
                this.spriteDEC.flashBG();
                this.delay(500);
                this.spriteIR.flashOperand();
                this.flashWire("IR:ADD", "PC:ADD");
                this.setPC(operand);
                this.spritePC.flashBG();
                this.delay(500);
            } else if (opcode == 13) {
                this.flashWire("IR:DEC", "DEC:IR");
                this.spriteDEC.flashBG();
                this.delay(500);
                this.spriteACC.flashBG();
                this.delay(500);
                if (this.getACC() == 0) {
                    jumping = true;
                    this.spriteIR.flashOperand();
                    this.flashWire("IR:ADD", "PC:ADD");
                    this.setPC(operand);
                    this.spritePC.flashBG();
                    this.delay(500);
                }
            } else if (opcode == 14) {
                this.flashWire("IR:DEC", "DEC:IR");
                this.spriteDEC.flashBG();
                this.delay(500);
            } else if (opcode == 15) {
                this.flashWire("IR:DEC", "DEC:IR");
                this.spriteDEC.flashBG();
                this.delay(500);
                this.halted = true;
            }
            if (this.getPC() < 126) {
                if (!jumping) {
                    this.flashWire("PC:ADD", "INC:ADD");
                    this.spriteINC.flashBG();
                    this.delay(500);
                    this.flashWire("INC:PC", "PC:INC");
                    this.setPC(this.getPC() + 2);
                    this.spritePC.flashBG();
                    this.delay(500);
                    return;
                }
            } else {
                this.halted = true;
            }
            return;
        }
        catch (AbortedException abortedException) {
            this.halted = true;
            return;
        }
    }

    private void internalReset() {
        this.halted = false;
        this.setPC(0);
        this.setACC(0);
        this.spriteALU.clear();
        this.spriteIR.clear();
        this.stage.update(null);
        this.spritePC.flashBG();
        this.spriteACC.flashBG();
    }

    private boolean internalDone() {
        return this.getPC() == 128 || this.halted;
    }

    private Node makeNode(String name, int x, int y) {
        Node node = new Node(name, x, y);
        this.stage.addNode(node);
        return node;
    }

    private Node makeNode(String name, String xName, int y) {
        Node xNode = this.stage.nodeByName(xName);
        return this.makeNode(name, xNode.location().x, y);
    }

    private Node makeNode(String name, int x, String yName) {
        Node yNode = this.stage.nodeByName(yName);
        return this.makeNode(name, x, yNode.location().y);
    }

    private Node makeNode(String name, String xName, String yName) {
        Node xNode = this.stage.nodeByName(xName);
        Node yNode = this.stage.nodeByName(yName);
        return this.makeNode(name, xNode.location().x, yNode.location().y);
    }

    private SpriteRect makeRect(Color color, String xName, String yName) {
        Node xNode = this.stage.nodeByName(xName);
        Node yNode = this.stage.nodeByName(yName);
        SpriteRect rect = new SpriteRect(this.stage, color, xNode, yNode);
        rect.addStage(1);
        return rect;
    }

    private SpriteWire makeWire(String start, String end) {
        Node startNode = this.stage.nodeByName(start);
        Node endNode = this.stage.nodeByName(end);
        SpriteWire wire = new SpriteWire(this.stage, startNode, endNode);
        wire.addStage(1);
        return wire;
    }

    private SpriteLabel makeLabel(String text, int x, int y, int width, int height, int horPos) {
        int vertSpace = 4;
        SpriteLabel label = new SpriteLabel(this.stage, text, x, y - vertSpace, width, 0, horPos, 5);
        label.addStage(1);
        return label;
    }

    private void flashWire(String start, String end) throws AbortedException {
        Node startNode = this.stage.nodeByName(start);
        Node endNode = this.stage.nodeByName(end);
        endNode.animateFrom(startNode);
    }

    private int getDRAM(int address) {
        return this.spriteDRAM.getValue(address);
    }

    private void setDRAM(int address, int data) {
        this.spriteDRAM.setValue(address, data);
    }

    private int getIRAM(int address) {
        return this.spriteIRAM.getValue(address);
    }

    private void setIRAM(int address, int instruction) {
        this.spriteIRAM.setValue(address, instruction);
    }

    private int getACC() {
        return this.spriteACC.getValue();
    }

    private void setACC(int value) {
        this.spriteACC.setValue(value);
    }

    private int getPC() {
        return this.spritePC.getValue();
    }

    private void setPC(int value) {
        this.spritePC.setValue(value);
    }

    private void delay(int ms) throws AbortedException {
        if (this.stage.aborting()) {
            throw new AbortedException();
        }
        try {
            Thread.currentThread();
            Thread.sleep(ms);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

