/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Event;
import screen.CPU;
import util.FixedApplet;
import util.ImageButton;
import util.ImageButtonGroup;
import util.ImageLoader;
import util.Loader;
import util.State;

public class CPUSim
extends FixedApplet {
    CPU cpu;
    State state;
    ImageButton reset;
    ImageButton stop;
    ImageButton step;
    ImageButton play;
    ImageButton binaryMode;
    ImageButton symbolicMode;
    ImageButtonGroup modeGroup;
    ImageButton clearAll;
    ImageButton open;
    ImageButton save;
    ImageButton saveAs;
    static final String[] imageList = new String[]{"binary", "binaryDown", "clearAll", "clearAllDown", "ff", "ffOn", "play", "playOn", "play", "playOn", "rr", "rrOn", "open", "openDown", "save", "saveAs", "saveAsDown", "saveDisabled", "saveDown", "stop", "stopOn", "symbolic", "symbolicDown"};
    ImageLoader imageLoader;
    static final String[] classList = new String[]{"CPUSim", "CPUState", "screen.CPU", "screen.Letter", "screen.Node", "screen.Sprite", "screen.SpriteALU", "screen.SpriteBox", "screen.SpriteComponent", "screen.SpriteDRAM", "screen.SpriteEditBox", "screen.SpriteIR", "screen.SpriteIRAM", "screen.SpriteLabel", "screen.SpriteMUX", "screen.SpriteRAM", "screen.SpriteRect", "screen.SpriteWire", "screen.Stage", "screen.TextBox", "util.ButtonDialog", "util.ColorTools", "util.CPUTools", "util.FFCanvas", "util.FixedApplet", "util.Global", "util.ImageButton", "util.ImageButtonGroup", "util.ImageLoader", "util.MultiLineLabel", "util.Queue", "util.Statable", "util.State"};
    Loader loader;

    public void fixedInit() {
        this.imageLoader = new ImageLoader(this, imageList);
        this.loader = new Loader(classList);
    }

    public void fixedStart() {
        this.setLayout(null);
        this.setBackground(new Color(102, 102, 102));
        this.cpu = new CPU(this);
        this.add(this.cpu);
        this.reset = new ImageButton("reset", this.imageLoader.getImage("rrOn"), this.imageLoader.getImage("rr"), null);
        this.add(this.reset);
        this.reset.reshape(0, 299, 51, 51);
        this.stop = new ImageButton("stop", this.imageLoader.getImage("stopOn"), this.imageLoader.getImage("stop"), null);
        this.stop.reshape(51, 299, 51, 51);
        this.add(this.stop);
        this.step = new ImageButton("step", this.imageLoader.getImage("ffOn"), this.imageLoader.getImage("ff"), null);
        this.step.reshape(102, 299, 51, 51);
        this.add(this.step);
        this.play = new ImageButton("play", this.imageLoader.getImage("playOn"), this.imageLoader.getImage("play"), null);
        this.play.reshape(153, 299, 51, 51);
        this.add(this.play);
        this.modeGroup = new ImageButtonGroup();
        this.symbolicMode = new ImageButton("symbolic", this.imageLoader.getImage("symbolicDown"), this.imageLoader.getImage("symbolic"), null, this.modeGroup);
        this.symbolicMode.reshape(204, 299, 80, 25);
        this.add(this.symbolicMode);
        this.binaryMode = new ImageButton("binary", this.imageLoader.getImage("binaryDown"), this.imageLoader.getImage("binary"), null, this.modeGroup);
        this.binaryMode.reshape(204, 324, 80, 25);
        this.add(this.binaryMode);
        this.modeGroup.setCurrent(this.symbolicMode);
        this.clearAll = new ImageButton("clearAll", this.imageLoader.getImage("clearAllDown"), this.imageLoader.getImage("clearAll"), null);
        this.clearAll.reshape(308, 299, 80, 50);
        this.add(this.clearAll);
        this.open = new ImageButton("open", this.imageLoader.getImage("openDown"), this.imageLoader.getImage("open"), null);
        this.open.reshape(398, 299, 60, 50);
        this.add(this.open);
        this.save = new ImageButton("save", this.imageLoader.getImage("saveDown"), this.imageLoader.getImage("save"), this.imageLoader.getImage("saveDisabled"));
        this.save.reshape(460, 299, 60, 50);
        this.add(this.save);
        this.saveAs = new ImageButton("saveAs", this.imageLoader.getImage("saveAsDown"), this.imageLoader.getImage("saveAs"), null);
        this.saveAs.reshape(520, 299, 80, 50);
        this.add(this.saveAs);
        this.state = new State(this, "CPUSim.dat");
        CPUState.spriteDRAM = this.cpu.spriteDRAM;
        CPUState.spriteIRAM = this.cpu.spriteIRAM;
        this.state.load();
        this.save.enable(this.state.canSave());
    }

    public void fixedStop() {
        this.removeAll();
        if (this.cpu != null) {
            this.cpu.dispose();
            this.cpu = null;
        }
        if (this.state != null) {
            this.state.dispose();
            this.state = null;
        }
    }

    public void fixedDestroy() {
        if (this.imageLoader != null) {
            this.imageLoader.dispose();
        }
        if (this.loader != null) {
            this.loader.dispose();
        }
        this.imageLoader = null;
        this.loader = null;
    }

    public boolean keyDown(Event evt, int key) {
        if (key == 27) {
            this.listAllThreads();
            return true;
        }
        return false;
    }

    public boolean action(Event evt, Object what) {
        if (evt.target == this.reset) {
            this.cpu.reset();
            return true;
        }
        if (evt.target == this.stop) {
            this.cpu.stop();
            return true;
        }
        if (evt.target == this.step) {
            this.cpu.step();
            return true;
        }
        if (evt.target == this.play) {
            this.cpu.play();
            return true;
        }
        if (evt.target == this.binaryMode || evt.target == this.symbolicMode) {
            this.cpu.changeMode(this.binaryMode.getState() ? 2 : 1);
            return true;
        }
        if (evt.target == this.clearAll) {
            this.cpu.clear();
            this.state.clearSave();
            return true;
        }
        if (evt.target == this.open) {
            this.cpu.reset();
            if (this.cpu.editWrite()) {
                CPUState.spriteDRAM = this.cpu.spriteDRAM;
                CPUState.spriteIRAM = this.cpu.spriteIRAM;
                this.state.loadFromDialog();
                this.cpu.updateStage();
            }
            this.save.enable(this.state.canSave());
            return true;
        }
        if (evt.target == this.save) {
            this.cpu.reset();
            if (this.cpu.editWrite()) {
                CPUState.spriteDRAM = this.cpu.spriteDRAM;
                CPUState.spriteIRAM = this.cpu.spriteIRAM;
                this.state.save(new CPUState());
                this.cpu.updateStage();
            }
            this.save.enable(this.state.canSave());
            return true;
        }
        if (evt.target == this.saveAs) {
            this.cpu.reset();
            if (this.cpu.editWrite()) {
                CPUState.spriteDRAM = this.cpu.spriteDRAM;
                CPUState.spriteIRAM = this.cpu.spriteIRAM;
                this.state.saveAs(new CPUState());
                this.cpu.updateStage();
            }
            this.save.enable(this.state.canSave());
            return true;
        }
        return false;
    }

    private void print_thread_info(Thread t, String indent) {
        if (t == null) {
            return;
        }
        System.out.println(indent + "Thread: " + t.getName() + "  Priority: " + t.getPriority() + (t.isDaemon() ? " Daemon" : "") + (t.isAlive() ? "" : " Not Alive"));
    }

    private void list_group(ThreadGroup g, String indent) {
        if (g == null) {
            return;
        }
        int num_threads = g.activeCount();
        int num_groups = g.activeGroupCount();
        Thread[] threads = new Thread[num_threads];
        ThreadGroup[] groups = new ThreadGroup[num_groups];
        g.enumerate(threads, false);
        g.enumerate(groups, false);
        System.out.println(indent + "Thread Group: " + g.getName() + "; Max Priority: " + g.getMaxPriority() + (g.isDaemon() ? "; Daemon" : ""));
        int i = 0;
        while (i < num_threads) {
            this.print_thread_info(threads[i], indent + "    ");
            ++i;
        }
        int i2 = 0;
        while (i2 < num_groups) {
            this.list_group(groups[i2], indent + "    ");
            ++i2;
        }
    }

    private void listAllThreads() {
        ThreadGroup current_thread_group;
        System.out.println("Listing threads:");
        ThreadGroup root_thread_group = current_thread_group = Thread.currentThread().getThreadGroup();
        ThreadGroup parent = root_thread_group.getParent();
        while (parent != null) {
            root_thread_group = parent;
            parent = parent.getParent();
        }
        this.list_group(root_thread_group, "    ");
    }
}

