% Example limit cycle
% Course: Analog and Digital Filter Design
% Lecture: Finite precision effects
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/04/13$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

% compute the filter coefficients
N = 9;         % Filter order
F = 0.5;       % Cutoff frequency 
Ap = 0.01;     % Maximum passband attenuation
As = 40;       % Minimum stopband attenuation
[z,p,k] = ellip(N,Ap,As,F);
[b,a]   = ellip(N,Ap,As,F);

% create fixed-point direct-form FIR filter
H = dfilt.df2(b,a);
hfvt = fvtool(H);
H1 = copy(H);
set(H1,'Arithmetic','fixed','CoeffWordLength',12);

set(hfvt, 'Filters', [H, H1],'ShowReference','off');
legend(hfvt,'Reference filter', '12 bits wordlength');
axis([0 1 -80 10]);

% fixed-point filtering; generating test input data
n1 = 1024;
k = 0:n1-1;
x = 0*k; x(1) = 1/4;
xin = fi(x,true,64,63);

H2 = copy(H1);
set(H2,'ProductMode','KeepMSB','ProductWordLength', 14);

% Processing
y1 = filter(H, xin);
y2 = filter(H2,xin);

xrange = (1:60);
figure
subplot(3,1,1)
stem(k(xrange),x(xrange))
ylabel('input')

subplot(3,1,2)
stem(k(xrange),y1(xrange))
ylabel('y_{FLOATING}')

subplot(3,1,3)
stem(k(xrange),y2.data(xrange))
ylabel('y_{FIXED-POINT}')
