% Example response of a discrete-time system
% Course: Analog and Digital Filter Design
% Lecture: Finite precision effects
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/04/12$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

% compute the filter coefficients
N = 9;         % Filter order
F = 0.5;       % Cutoff frequency 
Ap = 0.01;     % Maximum passband attenuation
As = 40;       % Minimum stopband attenuation
[z,p,k] = ellip(N,Ap,As,F);
[b,a]   = ellip(N,Ap,As,F);

% % create fixed-point direct-form FIR filter
H = dfilt.df1(b,a);
hfvt = fvtool(H);
set(H,'Arithmetic','fixed','CoeffWordLength',32);
%set(H,'Arithmetic','fixed');
H1 = copy(H);
set(H1,'Arithmetic','fixed','CoeffWordLength',12);

set(hfvt, 'Filters', [H, H1],'ShowReference','off');
legend(hfvt,'Reference filter', '12 bits wordlength');
axis([0 1 -80 10]);

% fixed-point filtering; generating test input data
n1 = 1024;
k = 0:n1-1;
f1 = 1/8; f2 = 340/1024;
Am = 1/(2^4);
x = Am*sin(2*pi*f1*k) + Am*sin(2*pi*f2*k);
xin = fi(x,true,64,63);
%xin2 = zeros(size(xin));
%xin2(1)=1;
%xin = xin2;

H2 = copy(H);
set(H2,'ProductMode','KeepMSB','ProductWordLength', 14);
y1 = filter(H,xin);
y2 = filter(H2,xin);
total_error = norm(double(y1.data)-double(y2.data))
max_deviation = norm(double(y1.data)-double(y2.data),inf)

X  = 20*log10( abs(fft(x)/(n1/2) ) );
Y1 = 20*log10( abs(fft(y1.data)/(n1/2) ) );
Y2 = 20*log10( abs(fft(y2.data)/(n1/2) ) );
Y12 = 20*log10( abs(fft(y1.data-y2.data)/(n1/2) ) );
nplot = 1:(n1/2+1);

figure, 
subplot(3,1,1)
plot((nplot-1)/(n1/2),X(nplot)), axis([0 1 -80 3]);
ylabel('X (dB)')
subplot(3,1,2)
plot((nplot-1)/(n1/2),Y1(nplot)), axis([0 1 -80 3]);
ylabel('Y (dB)')
subplot(3,1,3)
plot((nplot-1)/(n1/2),Y12(nplot)), axis([0 1 -80 3]);
ylabel('error (dB)')
legend('20 log_{10}|FFT(y_{FLOATING} - y_{FIXED-POINT})|')

xrange = (496+300:521+300);
figure, 
subplot(3,1,1)
plot(k(xrange),x(xrange))
ylabel('x')
subplot(3,1,2)
plot(k(xrange),y1.data(xrange),'b',k(xrange),y2.data(xrange),'r')
ylabel('y')
legend('y_{FLOATING}','y_{FIXED-POINT}')
subplot(3,1,3)
plot(k(xrange),y1.data(xrange)-y2.data(xrange))
ylabel('error')

figure,
dfont = 10;
N = 9;
textb=['{\itb}_0=' num2str(H2.numerator(1))];
texta='{\ita}_0=1';
for ind = 1:N
    drawdf1(2*(ind-1),1,4,5,dfont,ind,'b');
end
for ind = 1:fix(N/2)
    textb=[textb ', {\itb}_{' num2str(ind) '}=' num2str(H2.numerator(ind+1))];
    texta=[texta ', {\ita}_{' num2str(ind) '}=' num2str(H2.denominator(ind+1))];
end
 ind = fix(N/2)+1;
 textb2=['{\itb}_{' num2str(N) '}=' num2str(H2.numerator(N+1))];
 texta2=['{\ita}_{' num2str(ind) '}=' num2str(H2.denominator(ind+1))];
for ind = N-1:-1:fix(N/2)+1
    textb2=[textb2 ', {\itb}_{' num2str(ind) '}=' num2str(H2.numerator(ind+1))];
end
for ind = fix(N/2)+2:N
    texta2=[texta2 ', {\ita}_{' num2str(ind) '}=' num2str(H2.denominator(ind+1))];
end

drawin(1, 7, '\itx',2,4,dfont+1,'b');
drawout(2*(N+1), 2, '\it y',0,4,dfont+1,'b');
drawlvh(1, 9, 2, 10,0,'b');
drawmult(1, 7, 9, ' ' , '{\itb}_0',1,1,dfont,'b');
drawlvh(1, 6, 1, 5,0,'b');
drawlvh(2*(N+1), 2, 1, 6,0,'b');
text(-1,13.5,textb,'FontSize',dfont+2,'FontName','Times'); 
text(-1,12,textb2,'FontSize',dfont+2,'FontName','Times')
text(-1,0,texta,'FontSize',dfont+2,'FontName','Times'); 
text(-1,-1.5,texta2,'FontSize',dfont+2,'FontName','Times')

drawlvh(2*(N+1), 10, -1, 11,0,'b');
drawlvh(-1, 11, 2, 2,0,'b');

set(gcf,'Color',[1 1 0.9])

return

subplot(3,1,2)
[h,w] = freqz(H1.Numerator,1);
M = -20*log10(abs(h));
plot(w/(2*pi),M), axis([0 0.5 -10 80])

subplot(3,2,5)
plot(w/(2*pi),M), axis([0 0.25 -2 2])

subplot(3,2,6)
plot(w/(2*pi),M), axis([0.25 0.5 20 60])

