% Example classic digital design
% Course: Analog and Digital Filter Design
% Lecture: Advanced digital filter design using Matlab
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/04/04$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clc; clear all; close all;
Fp = 1600;
Fs = 1696;
Ap = 0.2;
As = 40;
Fsamp = 8000;
Fnyquist = Fsamp/2;
Wp = Fp/Fnyquist;
Ws = Fs/Fnyquist;
% Wp and Ws are the passband and stopband edge frequencies, 
% normalized from 0 to 1 (where 1 corresponds to pi radians/sample)
[N, Wn] = ellipord(Wp, Ws, Ap, As)
[num,den] = ellip(N, Ap, As, Wn)
[H, f] = freqz(num, den, 16*512, Fsamp);
[Gd, fGd] = grpdelay(num,den,16*512,Fsamp);
plot(fGd,Gd);
xlabel('Frequency (Hz)')
ylabel('Group delay (samples)')
title(['Gd_{max} = ',num2str(max(Gd))])
figure
plot(f,-20*log10(abs(H)));
xlabel('Frequency (Hz)')
ylabel('Attenuation (dB)')