% e = y22CauerElements[num,den]  returns element values of an LC 
% Singly Terminated Ladder Realization with Zeros at the Origin.
% Authors: Dejan V. Tosic, Miroslav D. Lutovac
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/02/20$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

function e = y22CauerElements(num, den) 
a = length(den); b = length(num); m = max([a, b]); 
if a > b
  e = [0]; num1 = num; den1 = den;
else
  [K, q] = extractMonom(num, den); 
  e = [K]; num1 = q(2:length(q)); den1 = den;
end
for i = 1:(m-1)
  [K, q] = extractMonom(den1, num1); 
  e = [e, K]; den1 = num1; num1 = q(2:length(q)); 
end
