
clear all, close all, clc, format long e

% Add DrawFilt to the MATLAB path
path(path,'C:\afd\DrawFilt')

% Attenuation-limit specification
Fp = 3000;
Fs = 3225;
Ap = 0.05;
As = 45;
spec = [Fp Fs Ap As];
numberOfDigits = 3;

% AFDesign summary
% Design D3a summary for spec lowpass   
%   3.0000e+003  3.2250e+003  5.0000e-002  4.5000e+001
%  ORDER ............  nD = 9
%  SELECTIVITY factor  aD = 1.0527
%  RIPPLE factor ....  eD = 0.10761
%  fp-FREQUENCY ..... fpD = 3000
%  NUMERATOR and DENOMINATOR coefficients numD, denD =
%                               3.328816782336827e-039
%     2.027687835473837e-036    1.175047602822185e-034
%                          0    5.459628733197339e-030
%     5.774671016463456e-027    1.298880888178889e-025
%                          0    3.052833349564078e-021
%     5.421061703242372e-018    4.963673133967950e-017
%                          0    7.009949241558935e-013
%     2.094337450980868e-009    7.319461433402855e-009
%                          0    5.558983169500679e-005
%     2.880004417128133e-001    2.880004417128133e-001
%  FILTER order = 9, MAX Quality Factor, Qmax = 38.1283
%  0.797 seconds.    Last coefficient is the free term.
 
numD3a = [2.027687835473837e-036
                         0
    5.774671016463456e-027
                         0
    5.421061703242372e-018
                         0
    2.094337450980868e-009
                         0
    2.880004417128133e-001]';

denD3a = [3.328816782336827e-039
    1.175047602822185e-034
    5.459628733197339e-030
    1.298880888178889e-025
    3.052833349564078e-021
    4.963673133967950e-017
    7.009949241558935e-013
    7.319461433402855e-009
    5.558983169500679e-005
    2.880004417128133e-001]';

denD3a = denD3a/numD3a(end);
numD3a = numD3a/numD3a(end);

% AFDesign summary
% Design D5 summary for spec lowpass   
%   3.0000e+003  3.2250e+003  5.0000e-002  4.5000e+001
%  ORDER ............  nD = 11
%  SELECTIVITY factor  aD = 1.0996
%  RIPPLE factor ....  eD = 0.004394
%  fp-FREQUENCY ..... fpD = 2935.4125
%  NUMERATOR and DENOMINATOR coefficients numD, denD =
%                               1.190312455333491e-047
%     7.887411808802928e-045    8.711518558636330e-043
%                          0    4.536164234538594e-038
%     3.784408904361982e-035    1.662230272845853e-033
%                          0    4.862143513972382e-029
%     5.957236560548133e-026    1.144342036956618e-024
%                          0    2.213175332117834e-020
%     4.187105743333921e-017    3.517286201189285e-016
%                          0    4.497706010140330e-012
%     1.364893697114514e-008    4.591014633392960e-008
%                          0    3.297871400271468e-004
%     1.685470638830275e+000    1.685470638830274e+000
%  FILTER order = 11, MAX Quality Factor, Qmax = 25.4473
%  4.422 seconds.    Last coefficient is the free term.
 
numD5 = [7.887411808802928e-045
                         0
    3.784408904361982e-035
                         0
    5.957236560548133e-026
                         0
    4.187105743333921e-017
                         0
    1.364893697114514e-008
                         0
    1.685470638830275e+000]';

denD5 = [1.190312455333491e-047
    8.711518558636330e-043
    4.536164234538594e-038
    1.662230272845853e-033
    4.862143513972382e-029
    1.144342036956618e-024
    2.213175332117834e-020
    3.517286201189285e-016
    4.497706010140330e-012
    4.591014633392960e-008
    3.297871400271468e-004
    1.685470638830274e+000]';

denD5 = denD5/numD5(end);
numD5 = numD5/numD5(end);

% validate frequency response
f = 1:1:8000;
w = 2*pi*f;
HD3a = freqs(numD3a, denD3a, w);
HD5 = freqs(numD5, denD5, w);

disp('Singly Terminated Ladder Realization with Complex Zeros');

disp('*** Design D3a ***');
disp('Transfer function numerator = '); disp(numD3a');
disp('Transfer function denominator = '); disp(denD3a');
disp('Element values');
elementValuesD3a = y22ZeroShiftingElements(numD3a,denD3a);
elementValuesD3a2digits =precisionDigits(elementValuesD3a,numberOfDigits);
[numD3aR, denD3aR] = ladder9complex(elementValuesD3a);
[numD3aR2digits, denD3aR2digits] = ladder9complex(elementValuesD3a2digits);
HD3aR = freqs(numD3aR, denD3aR, w);
HD3aR2digits = freqs(numD3aR2digits, denD3aR2digits, w);
subplot(2,2,1)
plot(f, -20*log10(abs(HD3aR)), 'b', ...
     f, -20*log10(abs(HD3aR2digits)), 'r', ...
     f(1:400:end), -20*log10(abs(HD3a(1:400:end))), 'gx');
%legend('realized','2 digits','ideal')
subplot(2,2,2)
plot(f, -20*log10(abs(HD3aR)), 'b', ...
     f, -20*log10(abs(HD3aR2digits)), 'r', ...
     f(1:400:end), -20*log10(abs(HD3a(1:400:end))), 'gx');
axis([0 Fs -5*Ap 5*Ap])
subplot(2,2,3)
plot(f, -20*log10(abs(HD3aR)), 'b', ...
     f, -20*log10(abs(HD3aR2digits)), 'r', ...
     f(1:20:end), -20*log10(abs(HD3a(1:20:end))), 'gx');
axis([Fp Fs -5*Ap 2*As])
subplot(2,2,4)
plot(f, -20*log10(abs(HD3aR)), 'b', ...
     f, -20*log10(abs(HD3aR2digits)), 'r', ...
     f(1:400:end), -20*log10(abs(HD3a(1:400:end))), 'gx');
axis([Fs 2*Fs As/2 2*As])

disp(' ')
disp('*** Design D5 ***');
disp('Transfer function numerator = '); disp(numD5');
disp('Transfer function denominator = '); disp(denD5');
disp('Element values');
elementValuesD5 = y22ZeroShiftingElements(numD5,denD5);
elementValuesD52digits = precisionDigits(elementValuesD5,numberOfDigits);
[numD5R, denD5R] = ladder11complex(elementValuesD5);
[numD5R2digits, denD5R2digits] = ladder11complex(elementValuesD52digits);
HD5R = freqs(numD5R, denD5R, w);
HD5R2digits = freqs(numD5R2digits, denD5R2digits, w);
figure
subplot(2,2,1)
plot(f, -20*log10(abs(HD5R)), 'b', ...
      f, -20*log10(abs(HD5R2digits)), 'r', ...
      f(1:400:end), -20*log10(abs(HD5(1:400:end))), 'gx');
subplot(2,2,2)
plot(f, -20*log10(abs(HD5R)), 'b', ...
     f, -20*log10(abs(HD5R2digits)), 'r', ...
     f(1:400:end), -20*log10(abs(HD5(1:400:end))), 'gx');
axis([0 Fs -5*Ap 5*Ap])
subplot(2,2,3)
plot(f, -20*log10(abs(HD5R)), 'b', ...
     f, -20*log10(abs(HD5R2digits)), 'r', ...
     f(1:20:end), -20*log10(abs(HD5(1:20:end))), 'gx');
axis([Fp Fs -5*Ap 2*As])
subplot(2,2,4)
plot(f, -20*log10(abs(HD5R)), 'b', ...
     f, -20*log10(abs(HD5R2digits)), 'r', ...
     f(1:400:end), -20*log10(abs(HD5(1:400:end))), 'gx');
axis([Fs 2*Fs As/2 2*As])

% Design comparison
figure
plot(f, -20*log10(abs(HD3aR2digits)), 'r', ...
     f, -20*log10(abs(HD5R2digits)), 'b', ...
     [0 Fp], 2*[Ap Ap], 'k', ...
     [0 Fp], -2*[Ap Ap], 'k');
axis([0 Fs -5*Ap 5*Ap])

% Draw schematics
figure
subplot(2,1,1)
drawLadder9Complex(0,0,4,5,12,'r')
subplot(2,1,2)
drawLadder11Complex(0,0,4,5,12,'b')
