% Example classic analog design
% Course: Analog and Digital Filter Design
% Lecture: Advanced analog filter design using Matlab
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/02/27$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clc; clear all; close all;
Fp = 3000;
Fs = 3225;
Ap = 0.2;
As = 40;
Wp = 2*pi*Fp;
Ws = 2*pi*Fs;
[N, Wn] = ellipord(Wp, Ws, Ap, As, 's')
[num,den] = ellip(N, Ap, As, Wn, 's');
f = 1:100:16000;
H = freqs(num, den, 2*pi*f);
plot(f,-20*log10(abs(H)));
[Z,P,K] = ellip(N, Ap, As, Wn, 's');
Qmax = max( -abs(P)./(2*real(P)))