% afdesbut.m  AFD Buttons (script)
%   
%          Advanced Analog Filter Design - AFDesign
%   
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac, 1999/02/21
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.23 $  $Date: 2005/01/19 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac
%
                         
% This file is part of AFDesign toolbox for MATLAB.
% Refer to the file LICENSE.TXT for full details.
%                        
% AFDesign version 2.3, Copyright (c) 1999-2005 D. Tosic and M. Lutovac
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; see LICENSE.TXT for details.
%                       
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%                       
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc.,  59 Temple Place,  Suite 330,  Boston,
% MA  02111-1307  USA,  http://www.fsf.org/

%% calls:
%% aadesign.m, afddemo.m, afdopen.m, afdview.m, afdedit.m
%% afdplot.m, afdpass.m, afdtran.m, afdstop.m, afdzoom.m
%% afdd1.m, afdd2.m, afdd3a.m, afdd3b.m, afdd4a.m, afdd4b.m
%% afdd5.m, afd2d5.m, afd3d5.m, 

if exist('Dtype')==0
  Dtype='D1';
end

bb0close = uicontrol('String', 'close', 'Units', 'normalized' ...
     , 'Position', [0.93 0.94 0.07 0.05] ...
     , 'CallBack', 'close all');

bb1reset = uicontrol('String', 'reset', 'Units', 'normalized' ...
     , 'Position', [0.93 0.88 0.07 0.05] ...
     , 'CallBack', 'aadesign');

bb3grid = uicontrol('String', 'grid', 'Units', 'normalized' ...
     , 'Position', [0.93 0.76 0.07 0.05] ...
     , 'CallBack', 'grid');

uiINFO= uicontrol('String', 'info', 'Units', 'normalized' ...
     , 'Position', [0.93 0.54 0.07 0.05] ...
     , 'CallBack', 'clf,bafdinfo;afdesbut');
  
%--------------------------------------------------------------%
b1demo = uicontrol('String', 'Demo', 'Units', 'normalized' ...
     , 'Position', [0.0 0.0 0.08 0.05] ...
     , 'CallBack', ['clf, afddemo; afdesbut']);

b2open = uicontrol('String', 'Open', 'Units', 'normalized' ...
     , 'Position', [0.08 0.0 0.08 0.05] ...
     , 'CallBack', ['clf, bafdopen; afdesbu2']);

b3view = uicontrol('String', 'View', 'Units', 'normalized' ...
     , 'Position', [0.16 0.0 0.08 0.05] ...
     , 'CallBack', ['clf,afdview; afdesbut']);

b4edit = uicontrol('String', 'Edit', 'Units', 'normalized' ...
     , 'Position', [0.24 0.0 0.08 0.05] ...
     , 'CallBack', 'afdedit;');

%--------------------------------------------------------------%

b5plot = uicontrol('String', 'Plot', 'Units', 'normalized' ...
     , 'Position', [0.93 0.28 0.07 0.05] ...
     , 'CallBack', ['clf;moreaxis=afdplot(numD,denD,speca,filnumb,moreaxis,Dtype);afdesbut']);

b6pass = uicontrol('String', 'Pass', 'Units', 'normalized' ...
     , 'Position', [0.93 0.21 0.07 0.05] ...
     , 'CallBack', 'clf;moreaxis=afdpass(numD,denD,speca,filnumb,moreaxis,Dtype);afdesbut');

b7tran = uicontrol('String', 'Tran', 'Units', 'normalized' ...
     , 'Position', [0.93 0.14 0.07 0.05] ...
     , 'CallBack', 'clf;moreaxis=afdtran(numD,denD,speca,filnumb,moreaxis,Dtype);afdesbut');

b8stop = uicontrol('String', 'Stop', 'Units', 'normalized' ...
     , 'Position', [0.93 0.07 0.07 0.05] ...
     , 'CallBack', 'clf;moreaxis=afdstop(numD,denD,speca,filnumb,moreaxis,Dtype);afdesbut');

b9zoom = uicontrol('String', 'Zoom', 'Units', 'normalized' ...
     , 'Position', [0.93 0.0 0.07 0.05] ...
     , 'CallBack', 'afdzoom;');

%--------------------------------------------------------------%

b10d1 = uicontrol('String', 'D1', 'Units', 'normalized' ...
     , 'Position', [0.0 0.07 0.05 0.05] ...
     , 'CallBack', 'bafdd1; afdesbut;Dtype=''D1'';');

b11d2 = uicontrol('String', 'D2', 'Units', 'normalized' ...
     , 'Position', [0.0 0.12 0.05 0.05] ...
     , 'CallBack', 'bafdd2; afdesbut;Dtype=''D2'';');

b12d3a = uicontrol('String', 'D3a', 'Units', 'normalized' ...
     , 'Position', [0.0 0.17 0.05 0.05] ...
     , 'CallBack', 'bafdd3a; afdesbut;Dtype=''D3a'';');

b13d3b = uicontrol('String', 'D3b', 'Units', 'normalized' ...
     , 'Position', [0.0 0.22 0.05 0.05] ...
     , 'CallBack', 'bafdd3b; afdesbut;Dtype=''D3b'';');

b14d4a = uicontrol('String', 'D4a', 'Units', 'normalized' ...
     , 'Position', [0.0 0.27 0.05 0.05] ...
     , 'CallBack', 'bafdd4a; afdesbut;Dtype=''D4a'';');

b15d4b = uicontrol('String', 'D4b', 'Units', 'normalized' ...
     , 'Position', [0.0 0.32 0.05 0.05] ...
     , 'CallBack', 'bafdd4b; afdesbut;Dtype=''D4b'';');

b15d5 = uicontrol('String', 'D5', 'Units', 'normalized' ...
     , 'Position', [0.0 0.37 0.05 0.05] ...
     , 'CallBack', 'bafdd5; afdesbut;Dtype=''D5'';');

b152d5 = uicontrol('String', '2D5', 'Units', 'normalized' ...
     , 'Position', [0.0 0.42 0.05 0.05] ...
     , 'CallBack', 'bafd2d5; afdesbut;Dtype=''2D5'';');

%--------------------------------------------------------------%

b16n = uicontrol('Style', 'text' ...
     , 'String', ['n=',num2str(nmin+ninc)] ...
     , 'Units', 'normalized', 'BackgroundColor',[0.9 0.9 0.9] ...
     , 'Position', [0.0 0.95 0.05 0.04]);

b17np = uicontrol('String', 'n+', 'Units', 'normalized' ...
     , 'Position', [0.0 0.90 0.05 0.04] ...
     , 'CallBack', ['ninc1=ninc+1;', ...
                    'if ninc1>nincmax;', ...
                    'ninc=nincmin;', ...
                    'else;', ...
                    'ninc=ninc1;', ...
                    'end;', ...
                    'set(b16n,''String'',[''n='',num2str(nmin+ninc)]);', ...
                    'if fig2;', ...
                    'set(eb8,''String'',num2str(ninc));', ...
                    'end;']);

b17nm = uicontrol('String', 'n-', 'Units', 'normalized' ...
     , 'Position', [0.0 0.86 0.05 0.04] ...
     , 'CallBack', ['ninc1=ninc-1;', ...
                    'if ninc1<nincmin;', ...
                    'ninc=nincmax;', ...
                    'else;', ...
                    'ninc=ninc1;', ...
                    'end;', ...
                    'set(b16n,''String'',[''n='',num2str(nmin+ninc)]);', ...
                    'if fig2;', ...
                    'set(eb8,''String'',num2str(ninc));', ...
                    'end;']);

%--------------------------------------------------------------%
