function X = afdxnai(n,a,i)

% afdxnai.m  AFD i-th zero X(n,ksi,i) of elliptic rational function
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

X = ellipj( ((2*i-1)/n + 1)*ellipke(1/a^2), 1/a^2);

if abs(n-2*fix(n/2)) == 1
  if i == (n+1)/2;
    X = 0;
  end
end
