% afdsview.m  AFDS view current specification (script)
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

delete(gca);
axis off;

text(0,0.9, 'Current lowpass attenuation limits specification')
text(0,0.8, ['Fpass = ', num2str(speca(1)), ' Hz']);
text(0,0.7, ['Fstop = ', num2str(speca(2)), ' Hz']);
text(0,0.6, ['Apass = ', num2str(speca(3)), ' dB']);
text(0,0.5, ['Astop = ', num2str(speca(4)), ' dB']);
text(0,0.4, 'Fpass = passband edge frequency in Hz');
text(0,0.3, 'Fstop = stopband edge frequency in Hz')
text(0,0.2, 'Apass = maximum passband attenuation in dB')
text(0,0.1, 'Astop = minimum stopband attenuation in dB')
