function h = afdsplan(N,Amin,Amax,Emin,Emax)

% afdsplan.m  AFDS planes
%
% afdsplan(N,Amin,Amax,Emin,Emax) plots the design space
%                        of IIR elliptic (Cauer) filters
%                            and returns the plot handle
%
% N is a vector of filter orders;
% Amin, Amax are vectors of min and max selectivities;
% Emin Emax are vectors of min and max ripples in passband.
%
% The design space is a set of the form
% {N(k),Amin(k),Amax(k),Emin(k),Emax(k)}
% k = 1, 2, ..., length(N)
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

Mx = []; My = []; Mz = [];
for k = 1:length(N)
   n1 = N(k); a1 = Amin(k); a2 = Amax(k);
              e1 = Emin(k); e2 = Emax(k);
   x = [a1 a2 a2 a1 a1];
   y = [e1 e1 e2 e2 e1];
   z = [n1 n1 n1 n1 n1];
   Mx = [Mx; x];
   My = [My; y];
   Mz = [Mz; z];
end
Mx = Mx'; My = My'; Mz = Mz';

h = plot3(Mx,My,Mz);
