function Nindex=afdscubm(dstable,Nindex,Nlength)

% afdscubm.m  AFDS design subspace for the previous order (n=n-1)
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

%  calls:
%% afdsbox.m

Nindex = Nindex - 1;
if Nindex < 1, Nindex = Nlength;, end

afdsbox(dstable(Nindex,2), dstable(Nindex,3), ...
        dstable(Nindex,4), dstable(Nindex,5), ...
        dstable(Nindex,6), dstable(Nindex,7));

xlabel('x', 'FontName','Symbol', 'FontSize',18);
ylabel('e', 'FontName','Symbol', 'FontSize',18);
zlabel('fp', 'FontName','Times', 'FontSize',18);

title(['design subspace for order n=', num2str(dstable(Nindex,1))])
