function h = afdscube(dstable)

% afdscube.m  AFDS selectivity-ripple-frequency
%                  design space cuboids
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

%  calls:
%% afdswire.m

N = dstable(:,1);
Xmin = dstable(:,2);
Xmax = dstable(:,3);
Ymin = dstable(:,4);
Ymax = dstable(:,5);
Zmin = dstable(:,6);
Zmax = dstable(:,7);

colorset = ['y','g','c','r','m','b'];
colornum = length(colorset);

for k = 1:length(N)

 colorind = rem(k,colornum);
 if colorind==0
  colorind = colornum;
 end
 wirecolor = colorset(colorind);

 afdswire(Xmin(k),Xmax(k),Ymin(k),Ymax(k),Zmin(k),Zmax(k),wirecolor);

 hold on;

end

xlabel('x', 'FontName','Symbol', 'FontSize',18);
ylabel('e', 'FontName','Symbol', 'FontSize',18);
zlabel('fp', 'FontName','Times', 'FontSize',18);

title('selectivity-ripple-frequency design space cuboids');

hold off;
