function [dstable, ...
          Nmin,Nmax, Nlength,Nindex, ...
          Xmin,Xmax, Emin,Emax, FPmin,FPmax, ...
          cubeaxis,caseaxis] = afdscomp(speca)

% afdscomp.m  AFDS compute design space
%             WARNING: can take several minutes to execute!
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

%  calls:
%% afda2k.m, afdnell.m, afdncheb.m, afdnbut.m, afdds.m, afdstabl.m


t0 = clock;

clc
format short e

disp('Advanced Filter Design Space')

Fp = speca(1);
Fs = speca(2);
Ap = speca(3);
As = speca(4);

disp('Lowpass attenuation limits specification')
disp(['Fp = ', num2str(Fp), ' Hz'])
disp(['Fs = ', num2str(Fs), ' Hz'])
disp(['Ap = ', num2str(Ap), ' dB'])
disp(['As = ', num2str(As), ' dB'])

Kp = afda2k(Ap);
Ks = afda2k(As);
speck = [Fp, Fs, Kp, Ks];

disp('Characteristic-function limits specification')
disp(['Kp = ', num2str(Kp)])
disp(['Ks = ', num2str(Ks)])

nellip = afdnell(Fp,Fs,Kp,Ks);
ncheb  = afdncheb(Fp,Fs,Kp,Ks);
nbut   = afdnbut(Fp,Fs,Kp,Ks);

disp('Order of elliptic, Chebyshev and Butterworth approximation')
disp(['n_elliptic = ', num2str(nellip)])
disp(['n_chebyshev = ', num2str(ncheb)])
disp(['n_butterworth = ', num2str(nbut)])

dstable = afdds(speck);
afdstabl(dstable);

% default spec yields
%ds=[n  xi_min  xi_max  e_min       e_max    fp_min  fp_max]
%ds=[8  1.0428  1.0832  7.5786e-2   0.21709  2.9772  3.0925
%    9  1.0220  1.0981  1.8469e-2   0.21709  2.9370  3.1556
%   10  1.0114  1.1201  3.6867e-3   0.21709  2.8791  3.1888
%   11  1.0059  1.1517  5.7868e-4   0.21709  2.8002  3.2062
%   12  1.0030  1.1966  6.7599e-5   0.21709  2.6951  3.2152
%   13  1.0016  1.2616  5.3913e-6   0.21709  2.5563  3.2199
%   14  1.0008  1.3595  2.5331e-7   0.21709  2.3722  3.2224
%   15  1.0004  1.5191  5.2851e-9   0.21709  2.1229  3.2236
%   16  1.0002  1.8222  2.5187e-11  0.21709  1.7698  3.2243]

Nmin = min(dstable(:,1));
Nmax = max(dstable(:,1));
Nlength = length(dstable(:,1));
Nindex = 0;

Xmin = min(dstable(:,2));
Xmax = max(dstable(:,3));
Emin = min(dstable(:,4));
Emax = max(dstable(:,5));
FPmin = min(dstable(:,6));
FPmax = max(dstable(:,7));

Xmin1 = dstable(1,2);
Xmax1 = dstable(1,3);
Emin1 = dstable(1,4);
Emax1 = dstable(1,5);
FPmin1 = dstable(1,6);
FPmax1 = dstable(1,7);

cubeaxis = [1, Xmax*1.01, 0, Emax*1.01, FPmin*0.99, FPmax*1.01];
caseaxis = [Xmin1*0.99, Xmax1, 0, Emax1*1.01, FPmin1, FPmax1];

t1 = etime(clock,t0);
disp(['Elapsed time is ',num2str(t1), ' seconds'])
