function h = afdscase(dstable,speca)

% afdscase.m  AFDS basic design cases
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

%  calls:
%% afdswire.m

Fp = speca(1);
Fs = speca(2);
Kp = afda2k(speca(3));
Ks = afda2k(speca(4));

% n = afdnell(Fp,Fs,Kp,Ks);
% ksimin = afdxmin(n,Kp,Ks);
% ksimax = afdxmax(n,Fp,Fs,Kp,Ks);
% epsilonmin = Ks/afdl(n,ksimax);
% epsilonmax = Kp;
% fpmin = Fs/ksimax;
% fpmax = Fs/ksimin;

n = dstable(1,1);
Xmin = dstable(1,2);
Xmax = dstable(1,3);
Ymin = dstable(1,4);
Ymax = dstable(1,5);
Zmin = dstable(1,6);
Zmax = dstable(1,7);

ksimin = Xmin;
ksimax = Xmax;
epsilonmin = Ymin;
epsilonmax = Ymax;
fpmin = Zmin;
fpmax = Zmax;

afdswire(Xmin,Xmax,Ymin,Ymax,Zmin,Zmax,'b');
hold on;

xlabel('x', 'FontName','Symbol', 'FontSize',18);
ylabel('e', 'FontName','Symbol', 'FontSize',18);
zlabel('fp', 'FontName','Times', 'FontSize',18);
title('basic design cases');

plot3(...
      Fs/Fp,  epsilonmax,       Fp,    'go', ...
      Fs/Fp,  Ks/afdl(n,Fs/Fp), Fp,    'co', ...
      ksimin, epsilonmax,       Fp,    'rx', ...
      ksimin, epsilonmax,       fpmax, 'rx', ...
      ksimax, epsilonmax,       Fp,    'y*', ...
      ksimax, epsilonmin,       fpmin, 'y*'  ...
);

text( Fs/Fp,  epsilonmax,       Fp,    ' D1',  'VerticalAlignment', 'bottom' );
text( Fs/Fp,  Ks/afdl(n,Fs/Fp), Fp,    ' D2',  'VerticalAlignment', 'bottom' );
text( ksimin, epsilonmax,       Fp,    ' D3a', 'VerticalAlignment', 'bottom' );
text( ksimin, epsilonmax,       fpmax, ' D3b', 'VerticalAlignment', 'bottom' );
text( ksimax, epsilonmax,       Fp,    ' D4a', 'VerticalAlignment', 'bottom' );
text( ksimax, epsilonmin,       fpmin, ' D4b', 'VerticalAlignment', 'bottom' );

hold off;
