% afdsbutt.m  AFDS buttons (script)
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

%  calls:
%% afdsdemo.m, afdsuser.m, afdsview.m, afdscomp.m
%% afdspla1.m, afdspla2.m, afdspla3.m
%% afdscube.m, afdscubp.m, afdscubm.m, afdscase.m

bb0close = uicontrol('String', 'close', 'Units', 'normalized' ...
     , 'Position', [0.93 0.94 0.07 0.05] ...
     , 'CallBack', 'close(gcf)');

bb1reset = uicontrol('String', 'reset', 'Units', 'normalized' ...
     , 'Position', [0.93 0.88 0.07 0.05] ...
     , 'CallBack', 'afdspace');

%bb2white = uicontrol('String', 'white', 'Units', 'normalized' ...
%     , 'Position', [0.93 0.82 0.07 0.05] ...
%     , 'CallBack', 'whitebg');

bb3grid = uicontrol('String', 'grid', 'Units', 'normalized' ...
     , 'Position', [0.93 0.76 0.07 0.05] ...
     , 'CallBack', 'grid');

bb4full = uicontrol('String', 'full', 'Units', 'normalized' ...
     , 'Position', [0.93 0.70 0.07 0.05] ...
     , 'CallBack', 'set(fig1,''Position'',svgasize)');

bb5small = uicontrol('String', 'small', 'Units', 'normalized' ...
     , 'Position', [0.93 0.64 0.07 0.05] ...
     , 'CallBack', 'set(fig1,''Position'',initsize)');

bb6azp = uicontrol('String', '+AZ', 'Units', 'normalized' ...
     , 'Position', [0.93 0.58 0.07 0.05] ...
     , 'CallBack', 'cubeview=cubeview+[10 0];view(cubeview);');

bb7elp = uicontrol('String', '+EL', 'Units', 'normalized' ...
     , 'Position', [0.93 0.52 0.07 0.05] ...
     , 'CallBack', 'cubeview=cubeview+[0 10];view(cubeview);;');

bb8azm = uicontrol('String', '-AZ', 'Units', 'normalized' ...
     , 'Position', [0.93 0.46 0.07 0.05] ...
     , 'CallBack', 'cubeview=cubeview+[-10 0];view(cubeview);');

bb9elm = uicontrol('String', '-EL', 'Units', 'normalized' ...
     , 'Position', [0.93 0.40 0.07 0.05] ...
     , 'CallBack', 'cubeview=cubeview+[0 -10];view(cubeview);');

bb102d = uicontrol('String', '2D', 'Units', 'normalized' ...
     , 'Position', [0.93 0.34 0.07 0.05] ...
     , 'CallBack', 'view(2);');

bb113d = uicontrol('String', '3D', 'Units', 'normalized' ...
     , 'Position', [0.93 0.28 0.07 0.05] ...
     , 'CallBack', 'cubeview=initview; view(cubeview);');

%--------------------------------------------------------------%

b1demo = uicontrol('String', 'Demo', 'Units', 'normalized' ...
     , 'Position', [0.0 0.0 0.08 0.05] ...
     , 'CallBack', 'afdsdemo;');

b2user = uicontrol('String', 'User', 'Units', 'normalized' ...
     , 'Position', [0.08 0.0 0.08 0.05] ...
     , 'CallBack', 'afdsuser;');

b3view = uicontrol('String', 'View', 'Units', 'normalized' ...
     , 'Position', [0.16 0.0 0.08 0.05] ...
     , 'CallBack', 'afdsview');

b4space = uicontrol('String', 'Space', 'Units', 'normalized' ...
     , 'Position', [0.85 0.0 0.08 0.05] ...
     , 'CallBack', ['[dstable,Nmin,Nmax,Nlength,Nindex,', ...
                    'Xmin,Xmax,Emin,Emax,FPmin,FPmax,', ...
                    'cubeaxis,caseaxis]=afdscomp(speca);']);

b5table = uicontrol('String', 'Table', 'Units', 'normalized' ...
     , 'Position', [0.93 0.0 0.07 0.05] ...
     , 'CallBack', 'afdstabl(dstable)');

%--------------------------------------------------------------%

b6plane1 = uicontrol('String', 'plane1', 'Units', 'normalized' ...
     , 'Position', [0.0 0.06 0.08 0.05] ...
     , 'CallBack', 'afdspla1;');

b7plane2 = uicontrol('String', 'plane2', 'Units', 'normalized' ...
     , 'Position', [0.0 0.11 0.08 0.05] ...
     , 'CallBack', 'afdspla2;');

b8plane3 = uicontrol('String', 'plane3', 'Units', 'normalized' ...
     , 'Position', [0.0 0.16 0.08 0.05] ...
     , 'CallBack', 'afdspla3;');

b9case = uicontrol('String', 'cases', 'Units', 'normalized' ...
     , 'Position', [0.0 0.22 0.08 0.05] ...
     , 'CallBack', ['afdscase(dstable,speca);', ...
                    'cubeview=caseview; view(cubeview);', ...
                    'axis(caseaxis);']);

b10cubes = uicontrol('String', 'cubes', 'Units', 'normalized' ...
     , 'Position', [0.0 0.94 0.08 0.05] ...
     , 'CallBack', ['afdscube(dstable);', ...
                    'cubeview=initview; view(cubeview);', ...
                    'axis(cubeaxis);']);

b11cubep = uicontrol('String', 'cube+', 'Units', 'normalized' ...
     , 'Position', [0.0 0.89 0.08 0.05] ...
     , 'CallBack', ['Nindex=afdscubp(dstable,Nindex,Nlength);', ...
                    'cubeview=initview; view(cubeview);', ...
                    'axis(cubeaxis);']);

b12cubem = uicontrol('String', 'cube-', 'Units', 'normalized' ...
     , 'Position', [0.0 0.84 0.08 0.05] ...
     , 'CallBack', ['Nindex=afdscubm(dstable,Nindex,Nlength);', ...
                    'cubeview=initview; view(cubeview);', ...
                    'axis(cubeaxis);']);
%--------------------------------------------------------------%
