function q = afdqk(k)

% afdqk.m  AFD auxiliary function q(k)
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

 e = [1,5, 9, 13,  17,   21,    25,     29,      33,       37];
 c = [1,2,15,150,1707,20910,268616,3567400,48555069,673458874];

if k <= 1/sqrt(2)
   t = (1/2)*(1 - (1-k^2)^(1/4))/(1 + (1-k^2)^(1/4));
else
   t = (1/2)*(1 - sqrt(k))/(1 + sqrt(k));
end

s = sum(c.*( (ones(size(e))*t).^e));

if k <= 1/sqrt(2)
   q = s;
else
   q = exp(pi^2/log(s));
end
