function dsi = afddsi(n,speck)

% afddsi.m  AFD design subspace
% ds(i) = {i, ksimin, ksimax, epsilonmin, epsilonmax, fpmin, fpmax}
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac
%  calls:
%% afdxmin.m, afdxmax.m, afdl.m

Fp = speck(1);
Fs = speck(2);
Kp = speck(3);
Ks = speck(4);

xmin = afdxmin(n, Kp, Ks);
xmax = afdxmax(n, Fp, Fs, Kp, Ks);
emin  = Ks/afdl(n,xmax);
emax  = Kp;
fpmin = Fs/xmax;
fpmax = Fs/xmin;

dsi = [n xmin xmax emin emax fpmin fpmax];
