% [K,r] = polynomialDivideStep(num, den)
% performs the first step in dividing num by den
% Authors: Dejan V. Tosic, Miroslav D. Lutovac
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/02/20$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

function [K,r] = polynomialDivideStep(num, den)

n = length(num); 
d = length(den); 

if n < d
  K = [];
  r = num;
  return 
end

if n == d
  K = num(1)/den(1);
  r = num - den*K;
  r = r(2:end);
  if r == 0*(1:length(r))
    r = [];
  end
  return
end

K = num(1)/den(1);
z = 0*(1:(n-d));
r = num - [den*K, z];
r = r(2:end);
if r == 0*(1:length(r))
  r = [];
end
