% Example singly terminated ladder realization with zeros at the origin
% Course: Analog and Digital Filter Design
% Lecture: RLC realizations
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/02/20$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

% Add DrawFilt to the MATLAB path
path(path,'C:\afd\DrawFilt')

disp('Singly Terminated Ladder Realization with Zeros at the Origin');

num = [1 0];
den = [1 3 3 3 1];

disp(['Transfer function numerator = ', num2str(num)]);
disp(['Transfer function denominator = ', num2str(den)]);

[y22num, y22den] = y22FromTransferFunction(num,den);

disp(['y22 numerator = ', num2str(y22num)]);
disp(['y22 denominator = ', num2str(y22den)]);

elementValues = y22CauerElements(y22num, y22den);

printElementValues(elementValues);

subplot(2,1,1)
draw_y22_1
subplot(2,1,2)
draw_rlc_1ta

% Verification
Ro = 1;
Co = elementValues(1);
L1 = elementValues(2);
C1 = elementValues(3);
L2 = elementValues(4);
C2 = elementValues(5);
numH = [C2*Ro 0];
denH = [C1*C2*L1*L2 C1*C2*L2*Ro C1*L1+C2*(L1+L2) C1*Ro+C2*Ro 1];
disp(['Realized H(S) numerator = ', num2str(numH)]);
disp(['Realized H(S) denominator = ', num2str(denH)]);
