% Example LPLQ biquad
% Course: Analog and Digital Filter Design
% Lecture: Active RC
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/02/11$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

% Given a second-order lowpass transfer function we identify
fp = 2300;
wp = 2*pi*fp;
Qp = 1.2;

% Choose K < 1 
K  = 0.6;

% Choose 0.1 < P=R3/R1 < 10
P  = 3.3865; 

% Choose C4
nano = 10^(-9);
Cx = 3.3*nano;
C4 = Cx;

% Compute element values
C2 = 2*Qp^2*Cx*(1+(1+P^2)/(2*P));
R1 = 1/(wp*Cx*Qp*(1+P));
R3 = P*R1;
R11 = R1/K;
R12 = R1/(1-K);

disp(['R11 = ' num2str(R11)])
disp(['R12 = ' num2str(R12)])
disp(['R3 = ' num2str(R3)])
disp(['C2 = ' num2str(C2)])
disp(['C4 = ' num2str(C4)])

% Generate transfer function in terms of element values
num = R12;
den = [(C2*C4*R11*R12*R3) (C4*R11*R12+C4*R11*R3+C4*R12*R3) (R11+R12)];
f = 0:80:8000;
w = i*2*pi*f;
H = num./polyval(den,w);

subplot(2,1,1)
drawlplq(0,0,4,5,10,'b')

subplot(2,1,2)
plot(f,abs(H))
text(3000, 0.6, ...
    ['R_{11} = ' num2str(round(R11)) ' \Omega, ' ...
     'R_{12} = ' num2str(round(R12)) ' \Omega, ' ...
     'R_{3} = ' num2str(round(R3)) ' \Omega'])
text(4000, 0.4, ...
    ['C_{2} = ' num2str(round(C2/nano)) ' nF, ' ...
     'C_{4} = ' num2str(C4/nano) ' nF'])
xlabel('Frequency (Hz)')
ylabel('Magnitude')
